% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt3x_unzip.R
\name{unzip.gt3x}
\alias{unzip.gt3x}
\title{Unzip gt3x files}
\usage{
unzip.gt3x(path, verbose = TRUE, ...)
}
\arguments{
\item{path}{One of the following: (1) A path to a directory with
.gt3x files in which case they are all unzipped, or
(2) A character vector of direct paths to .gt3x files.}

\item{verbose}{print diagnostic messages}

\item{...}{arguments to pass to \code{\link{unzip_single_gt3x}}}
}
\value{
Returns a vector of paths to unzipped gt3x folders.
}
\description{
unzip.gt3x() makes it convenient to unzip multiple .gt3x files.
}
\details{
A .gt3x file is a zipped directory with two files: log.bin and info.txt.
This function simply unzips the contents of the directories.
}
\examples{

gt3xfile <-
  system.file(
    "extdata", "TAS1H30182785_2019-09-17.gt3x",
    package = "read.gt3x")
gt3xdirs <- unzip.gt3x(gt3xfile)
\dontrun{
# unzip a single .gt3x file
path <- gt3x_datapath(1)
gt3xdir <- unzip.gt3x(path)

# unzip multiple .gt3x files
dir <- gt3x_datapath()
gt3xdirs <- unzip.gt3x(dir)
}
tfile = tempfile()
testthat::expect_error(unzip.gt3x(c(dir, tfile)))
testthat::expect_error(unzip.gt3x(c("", "")))

}
\seealso{
Other file manipulations: 
\code{\link{gt3x_datapath}()},
\code{\link{is_gt3x}()},
\code{\link{list_gt3x}()}
}
\concept{file manipulations}
