% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{getReactableState}
\alias{getReactableState}
\title{Get the state of a reactable instance}
\usage{
getReactableState(outputId, name = NULL, session = NULL)
}
\arguments{
\item{outputId}{The Shiny output ID of the \code{reactable} instance.}

\item{name}{Name of a state value to get. One of \code{"page"}, \code{"pageSize"},
\code{"pages"}, or \code{"selected"}. If unspecified, all values will be returned
in a named list.}

\item{session}{The Shiny session object. Defaults to the current Shiny session.}
}
\value{
If \code{name} is specified, one of the following values:
\itemize{
\item \code{page}: the current page
\item \code{pageSize}: the page size
\item \code{pages}: the number of pages
\item \code{selected}: the selected rows - a numeric vector of row indices, or \code{NULL} if no rows are selected
}

If \code{name} is unspecified, \code{getReactableState()} returns a named list containing all values.

If the table has not been rendered yet, \code{getReactableState()} returns \code{NULL}.
}
\description{
\code{getReactableState()} gets the state of a reactable instance within a Shiny application.
}
\examples{
# Run in an interactive R session
if (interactive()) {

library(shiny)
library(reactable)

ui <- fluidPage(
  actionButton("prev_page_btn", "Previous page"),
  actionButton("next_page_btn", "Next page"),
  reactableOutput("table"),
  verbatimTextOutput("table_state")
)

server <- function(input, output) {
  output$table <- renderReactable({
    reactable(
      iris,
      showPageSizeOptions = TRUE,
      selection = "multiple"
    )
  })

  output$table_state <- renderPrint({
    state <- req(getReactableState("table"))
    print(state)
  })

  observeEvent(input$prev_page_btn, {
    # Change to the previous page
    page <- getReactableState("table", "page")
    if (page > 1) {
      updateReactable("table", page = page - 1)
    }
  })

  observeEvent(input$next_page_btn, {
    # Change to the next page
    state <- getReactableState("table")
    if (state$page < state$pages) {
      updateReactable("table", page = state$page + 1)
    }
  })
}

shinyApp(ui, server)
}

}
