% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{re2_extract}
\alias{re2_extract}
\alias{re2_extract_all}
\title{Extract matching patterns from a string.}
\usage{
re2_extract(string, pattern, anchor = UNANCHORED, parallel = FALSE,
  grain_size = 1e+05, ...)

re2_extract_all(string, pattern, anchor = UNANCHORED, parallel = FALSE,
  grain_size = 1e+05, ...)
}
\arguments{
\item{string}{a character vector}

\item{pattern}{a character vector or pre-compiled regular expressions}

\item{anchor}{see \code{\link{UNANCHORED}}}

\item{parallel}{use multithread}

\item{grain_size}{a minimum chunk size for tuning the behavior of parallel algorithms}

\item{...}{further arguments passed to \code{\link{re2}}}
}
\value{
A character vector for \code{\link{re2_extract}}, and a list for \code{\link{re2_extract_all}}.
}
\description{
Extract matching patterns from a string. Vectorised over string and pattern.
}
\examples{
re2_extract("yabba dabba doo", "(.)")
re2_extract_all("yabba dabba doo", "(.)")

str <- c("Aster", "Azalea x2", "Baby's Breath", "Bellflower")
re2_extract(str, "\\\\d")
re2_extract(str, "[a-z]+")
re2_extract(str, "\\\\b\\\\w{1,3}\\\\b")

# Extract all matches
re2_extract_all(str, "[A-Za-z]+")
re2_extract_all(str, "\\\\b\\\\w{1,3}\\\\b")
re2_extract_all(str, "\\\\d")

}
\seealso{
\code{\link{re2_match}} to extract matched groups.
}
