% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dryad_metadata.R
\name{dryad_metadata}
\alias{dryad_metadata}
\title{Download Dryad file metadata}
\usage{
dryad_metadata(doi, ...)
}
\arguments{
\item{doi}{(character) A Dryad DOI for a dataset of files within
a dataset}

\item{...}{Further args passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
named (list) with slots for:
\itemize{
\item desc: object metadata
\item files: file information
\item attributes: metadata about the metadata file
\item structMap: not sure what this is
}
}
\description{
Download Dryad file metadata
}
\examples{
\dontrun{
dryad_metadata('10.5061/dryad.1758')
dryad_metadata('10.5061/dryad.9t0n8/1')
dryad_metadata('10.5061/dryad.60699/3')
out <- dryad_metadata('10.5061/dryad.60699/5')
out$desc$text[out$desc$qualifier \%in\% c("pageviews", "downloads")]
}
}
