% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_content_hash.R
\name{drop_content_hash}
\alias{drop_content_hash}
\title{Compute Dropbox's content hash for one or more files}
\usage{
drop_content_hash(file)
}
\arguments{
\item{file}{A vector of filenames}
}
\value{
A character vector the same length as \code{file}.  Each
  element is 64 character string which is the unique hash.  Two
  files that have the same hash have the same contents.  Compare
  this hash of a local file with the \code{content_hash} field from
  \code{\link{drop_dir}} to see if you have the same file as
  dropbox.
}
\description{
Compute a "content hash" using the same algorithm as dropbox.  This
can be used to verify the content against the \code{content_hash}
field returned in \code{\link{drop_dir}}.
}
\details{
Dropbox returns a hash of file contents in \code{\link{drop_dir}}.
However, this is not a straightforward file hash.  Instead the file
is divided into 4MB chunks, each of those is hashed and then the
concatenation of the hashes is itself hashed (see
\href{https://www.dropbox.com/developers/reference/content-hash}{this
page} in the dropbox developer documentation for the details).
It's entirely unclear why it does not compute a hash of the file
itself, but here we are.
}
\examples{
\dontrun{
write.csv(mtcars, file = "mtt.csv")
drop_upload("mtt.csv")
files <- drop_dir()
# Dropbox's reported hash
files$content_hash[files$name == "mtt.csv"]
# Our computed hash:
drop_content_hash("mtt.csv")
}
}
