% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drop_file_ops.R
\name{drop_create}
\alias{drop_create}
\title{Creates a folder on Dropbox}
\usage{
drop_create(path = NULL, root = "auto", verbose = FALSE,
  dtoken = get_dropbox_token())
}
\arguments{
\item{path}{This is required The path to the new folder to create relative to
root.}

\item{root}{This is required. The root relative to which path is specified.
Valid values are auto (recommended and also the default), sandbox, and dropbox.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
Returns a list containing the following fields: "size", "rev", "thumb_exists",
"bytes", "modified", "path", "is_dir", "icon", "root", "revision"
}
\examples{
\dontrun{
drop_create(path = "foobar")
}
}

