% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsensitivity.R
\name{rdsensitivity}
\alias{rdsensitivity}
\title{Sensitivity analysis for RD designs under local randomization}
\usage{
rdsensitivity(
  Y,
  R,
  cutoff = 0,
  wlist,
  wlist_left,
  tlist,
  statistic = "diffmeans",
  p = 0,
  evalat = "cutoff",
  kernel = "uniform",
  fuzzy = NULL,
  ci = NULL,
  ci_alpha = 0.05,
  reps = 1000,
  seed = 666,
  nodraw = FALSE,
  quietly = FALSE
)
}
\arguments{
\item{Y}{a vector containing the values of the outcome variable.}

\item{R}{a vector containing the values of the running variable.}

\item{cutoff}{the RD cutoff (default is 0).}

\item{wlist}{the list of windows to the right of the cutoff. By default the program constructs 10 windows around the cutoffwith 5 observations each.}

\item{wlist_left}{the list of windows  to the left of the cutoff. If not specified, the windows are constructed symmetrically around the cutoff based on the values in wlist.}

\item{tlist}{the list of values of the treatment effect under the null to be evaluated. By default the program employs ten evenly spaced points within the asymptotic confidence interval for a constant treatment effect in the smallest window to be used.}

\item{statistic}{the statistic to be used in the balance tests. Allowed options are \code{diffmeans} (difference in means statistic), \code{ksmirnov} (Kolmogorov-Smirnov statistic) and \code{ranksum} (Wilcoxon-Mann-Whitney standardized statistic). Default option is \code{diffmeans}. The statistic \code{ttest} is equivalent to \code{diffmeans} and included for backward compatibility.}

\item{p}{the order of the polynomial for outcome adjustment model. Default is 0.}

\item{evalat}{specifies the point at which the adjusted variable is evaluated. Allowed options are \code{cutoff} and \code{means}. Default is \code{cutoff}.}

\item{kernel}{specifies the type of kernel to use as weighting scheme. Allowed kernel types are \code{uniform} (uniform kernel), \code{triangular} (triangular kernel) and \code{epan} (Epanechnikov kernel). Default is \code{uniform}.}

\item{fuzzy}{indicates that the RD design is fuzzy. \code{fuzzy} can be specified as a vector containing the values of the endogenous treatment variable, or as a list where the first element is the vector of endogenous treatment values and the second element is a string containing the name of the statistic to be used. Allowed statistics are \code{ar} (Anderson-Rubin statistic) and \code{tsls} (2SLS statistic). Default statistic is \code{ar}. The \code{tsls} statistic relies on large-sample approximation.}

\item{ci}{returns the confidence interval corresponding to the indicated window length. \code{ci} has to be a two-dimensional vector indicating the left and right limits of the window. Default alpha is .05 (95\% level CI).}

\item{ci_alpha}{Specifies value of alpha for the confidence interval. Default alpha is .05 (95\% level CI).}

\item{reps}{number of replications. Default is 1000.}

\item{seed}{the seed to be used for the randomization tests.}

\item{nodraw}{suppresses contour plot.}

\item{quietly}{suppresses the output table.}
}
\value{
\item{tlist}{treatment effects grid}
\item{wlist}{window grid}
\item{results}{table with corresponding p-values for each window and treatment effect pair.}
\item{ci}{confidence interval (if \code{ci} is specified).}
}
\description{
\code{rdsensitivity} analyze the sensitivity of randomization p-values
and confidence intervals to different window lengths.
}
\examples{
# Toy dataset
R <- runif(100,-1,1)
Y <- 1 + R -.5*R^2 + .3*R^3 + (R>=0) + rnorm(100)
# Sensitivity analysis
# Note: low number of replications to speed up process.
# The user should increase the number of replications.
tmp <- rdsensitivity(Y,R,wlist=seq(.75,2,by=.25),tlist=seq(0,5,by=1),reps=500)


}
\references{
Cattaneo, M.D., R. Titiunik and G. Vazquez-Bare. (2016). \href{https://rdpackages.github.io/references/Cattaneo-Titiunik-VazquezBare_2016_Stata.pdf}{Inference in Regression Discontinuity Designs under Local Randomization}. \emph{Stata Journal} 16(2): 331-367.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
