% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diversity.R
\name{plot_diversity}
\alias{plot_diversity}
\title{Plot diversity}
\usage{
plot_diversity(data)
}
\arguments{
\item{data}{object of class \code{tibble} (or \code{data.frame}); output of 
\code{subdiv}, \code{metadiv}, or any of the specific subcommunity- or 
metacommunity-level diversity functions.}
}
\description{
Simple function to plot diversity profiles.
}
\examples{
# Define metacommunity
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate subcommunity beta diversity (takes the relative entropy)
b <- raw_beta(meta)
res <- subdiv(b, 0:2)
plot_diversity(res)

# Calculate all measures of subcommunity diversity
res <- subdiv(meta, 0:2)
plot_diversity(res)

# Try a single population
pop <- c(1,3,4)
meta <- metacommunity(pop)
res <- meta_gamma(meta, 0:2)
plot_diversity(res)

# Calculate all measures of metacommunity diversity
res <- metadiv(meta, 0:2)
plot_diversity(res)

}
