% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_shimatani.R
\name{similarity_shimatani}
\alias{similarity_shimatani}
\title{Taxonomic similarity matrix}
\usage{
similarity_shimatani(data, lookup)
}
\arguments{
\item{data}{\eqn{S * N} \code{matrix}; population counts}

\item{lookup}{\code{data.frame} with colnames = c('Species', 'Genus', 
'Family', 'Subclass')}
}
\value{
Returns an \eqn{S * S} \code{matrix}; pair-wise taxonomic similarity
}
\description{
Calculates taxonomic similarity based on Shimatani's index of taxonomic 
similarity (see \emph{Details}).
}
\details{
Shimatani's taxonomic similarity index is defined:
\tabular{ll}{
\code{species.similarity} \tab 1 \cr
\code{genus.similarity} \tab 0.75 \cr
\code{family.similarity} \tab 0.5 \cr
\code{subclass.similarity} \tab 0.25 \cr
\code{other.similarity} \tab 0 \cr
}
}
\examples{
pop <- sample(1:50, 4)
lookup <- data.frame(Subclass=c("Sapindales", "Malvales", "Fabales", 
                                  "Fabales"),      
                     Family=c("Burseraceae", "Bombacaceae", "Fabaceae", 
                              "Fabaceae"), 
                     Genus=c("Protium", "Quararibea", "Swartzia", 
                             "Swartzia"),       
                     Species= c("tenuifolium", "asterolepis",
                                    "simplex var.grandiflora",
                                    "simplex var.ochnacea"))
similarity <- similarity_shimatani(pop, lookup)

}
\references{
Shimatani, K. 2001. On the measurement of species diversity 
incorporating species differences. Oikos 93:135–147.
}
