% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhs_flat.R
\name{read_dhs_flat}
\alias{read_dhs_flat}
\title{Read DHS flat file data set}
\usage{
read_dhs_flat(zfile, all_lower = TRUE, meta_source = NULL)
}
\arguments{
\item{zfile}{Path to `.zip` file containing flat file dataset, usually
ending in filename `XXXXXXFL.zip`}

\item{all_lower}{Logical indicating whether all value labels should be
lower case. Default to `TRUE`.}

\item{meta_source}{character string indicating metadata source file for data
dictionary. Default \code{NULL} first tried to use \code{.DCF} and then
{.SPS} if not found.}
}
\value{
A data frame. Value labels for each variable are stored as the
  `labelled` class from `haven`.
}
\description{
This function reads a DHS recode dataset from the zipped flat file dataset.
}
\examples{
mrfl_zip <- tempfile()
download.file("https://dhsprogram.com/data/model_data/dhs/zzmr61fl.zip",
              mrfl_zip,mode="wb")

mr <- rdhs:::read_dhs_flat(mrfl_zip)
attr(mr$mv213, "label")
class(mr$mv213)
head(mr$mv213)
table(mr$mv213)
table(haven::as_factor(mr$mv213))

}
\seealso{
\code{\link[haven]{labelled}}, \code{\link{read_dhs_dta}}.

For more information on the DHS filetypes and contents of distributed
dataset .ZIP files, see
\url{https://dhsprogram.com/data/File-Types-and-Names.cfm#CP_JUMP_10334}.
}
