% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PremiumRateService.R
\name{dfp_createPremiumRates}
\alias{dfp_createPremiumRates}
\title{PremiumRateService}
\usage{
dfp_createPremiumRates(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createPremiumRatesResponse
}
\description{
Provides methods for managing PremiumRate objects.
To use this service,
you need to have the new sales management solution enabled on your network.
If you do not see a "Sales" tab in <a
href="https://www.google.com/dfp">DoubleClick for Publishers (DFP)</a>, you
will not be able to use this service.
}
\details{
createPremiumRates

Creates a list of new PremiumRate objects.
}
\examples{
\dontrun{
 res <- dfp_createPremiumRates(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/PremiumRateService#createPremiumRates}{Google Documentation for createPremiumRates}
}
