% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreativeService.R
\name{dfp_createCreatives}
\alias{dfp_createCreatives}
\title{CreativeService}
\usage{
dfp_createCreatives(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCreativesResponse
}
\description{
Provides methods for adding, updating and retrieving Creative objects.
}
\details{
For a creative to run, it must be associated with a LineItem managed by
the LineItemCreativeAssociationService.#' Read more about creatives on
the <a href="https://support.google.com/dfp_premium/answer/3185155">DFP
Help Center</a>.

createCreatives

Creates new Creative objects.
}
\examples{
\dontrun{
 res <- dfp_createCreatives(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CreativeService#createCreatives}{Google Documentation for createCreatives}
}
