% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrderService.R
\name{dfp_createOrders}
\alias{dfp_createOrders}
\title{OrderService}
\usage{
dfp_createOrders(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createOrdersResponse
}
\description{
Provides methods for creating, updating and retrieving Order objects.
}
\details{
An order is a grouping of LineItem objects. Line items have a many-to-one
relationship with orders, meaning each line item can belong to only one
order, but orders can have multiple line items. An order can be used to
manage the line items it contains.

createOrders

Creates new Order objects.
}
\examples{
\dontrun{
request_data <- list('filterStatement'=list('query'="WHERE name = 'TestCompany1'"))
dfp_getCompaniesByStatement_result <- dfp_getCompaniesByStatement(request_data) 

request_data <- list(list(name='TestOrder', 
                          startDateTime=list(date=list(year=2018, month=12, day=1), 
                                             hour=0,
                                             minute=0,
                                             second=0,
                                             timeZoneID='America/New_York'),
                          endDateTime=list(date=list(year=2018, month=12, day=31), 
                                           hour=23,
                                           minute=59,
                                           second=59,
                                           timeZoneID='America/New_York'), 
                          notes='API Test Order', 
                          externalOrderId=99999, 
                          advertiserId=dfp_getCompaniesByStatement_result$id, 
                          traffickerId=dfp_getCurrentUser()$id))
dfp_createOrders_result <- dfp_createOrders(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/OrderService#createOrders}{Google Documentation for createOrders}
}
