% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarkovState.R
\docType{class}
\name{MarkovState}
\alias{MarkovState}
\title{A state in a Markov model}
\value{
Updated \code{MarkovState} object
}
\description{
An R6 class representing a state in a Markov model.
}
\details{
Represents a single state in a Markov model. A Markov model is 
a digraph in which states are nodes and transitions are arrows. Inherits 
from class \code{Node}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Node]{rdecision::Node}} -> \code{MarkovState}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MarkovState$new()}}
\item \href{#method-name}{\code{MarkovState$name()}}
\item \href{#method-set_cost}{\code{MarkovState$set_cost()}}
\item \href{#method-cost}{\code{MarkovState$cost()}}
\item \href{#method-utility}{\code{MarkovState$utility()}}
\item \href{#method-modvars}{\code{MarkovState$modvars()}}
\item \href{#method-clone}{\code{MarkovState$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Node" data-id="label">}\href{../../rdecision/html/Node.html#method-label}{\code{rdecision::Node$label()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Node" data-id="type">}\href{../../rdecision/html/Node.html#method-type}{\code{rdecision::Node$type()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \code{MarkovState}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$new(name, cost = as.numeric(NA), utility = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the state (character string).}

\item{\code{cost}}{The annual cost of state occupancy (numeric or 
\code{ModVar}). Set
as \code{NA} by default to help distinguish costs to be set with 
\code{set_cost} in future from those deliberately set to zero.}

\item{\code{utility}}{The utility associated with being in the state (numeric
or \code{ModVar}).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Utility must be in the range \code{[-Inf,1]}. If it is of type 
numeric,
the range is checked on object creation.
}

\subsection{Returns}{
An object of type \code{MarkovState}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
Accessor function to retrieve the state name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
State name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cost"></a>}}
\if{latex}{\out{\hypertarget{method-set_cost}{}}}
\subsection{Method \code{set_cost()}}{
Set the annual occupancy cost
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$set_cost(cost)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cost}}{The annual cost of state occupancy}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cost"></a>}}
\if{latex}{\out{\hypertarget{method-cost}{}}}
\subsection{Method \code{cost()}}{
Gets the annual cost of state occupancy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Annual cost; numeric.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-utility"></a>}}
\if{latex}{\out{\hypertarget{method-utility}{}}}
\subsection{Method \code{utility()}}{
Gets the utility associated with the state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$utility()}\if{html}{\out{</div>}}
}

\subsection{Details}{
If the state utility is a \code{ModVar} and its sampled
value exceeds 1, a warning is issued.
}

\subsection{Returns}{
Utility; numeric.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$modvars()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Find variables of type \code{ModVar} that have been 
specified as values associated with this \code{MarkovState}. 
Includes operands of these \code{ModVar}s, if they are expressions.
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarkovState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
