% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExprModVar.R
\docType{class}
\name{ExprModVar}
\alias{ExprModVar}
\title{\verb{ExprModVar} class}
\description{
An R6 class for a model variable constructed from an expression
involving other model variables.
}
\details{
A class to support expressions involving objects
of base class \code{ModVar}, which itself behaves like a 
model variable. For example, if \code{A} and
\code{B} are variables with base class \code{ModVar}
and \code{c} is a variable of type \code{numeric}, then
it is not possible to write, for example, 
\code{x <- 42*A/B + c}, because R cannot manipulate class
variables using the same operators as regular variables. 
But such forms of expression may be desirable in constructing a
model and this class provides a mechanism for doing so.
}
\note{
For many expressions involving model variables there will 
be no closed form expressions for the mean, standard deviation and
the quantiles. Therefore they are obtained by simulation, via
functions \code{mu_hat}, \code{sigma_hat} and \code{q_hat}.

For consistency with \code{ModVar}s which are not expressions, the
function \code{mean} returns the value of the expression when all
its operands take their mean values. This will, in general, not
be the mean of the expression distribution (which can be obtained
via \code{mu_hat}), but is the value normally used in the base
case of a model as the point estimate. As Briggs \emph{et al} note 
(section 4.1.1) "in all but the most non-linear models, the 
difference between the expectation over the output of a 
probabilistic model and that model evaluated at the mean values
of the input parameters, is likely to be modest."

Functions \code{SD}, \code{mode} and \code{quantile} return \code{NA}
because they do not necessarily have a closed form. The standard
deviation can be estimated by calling \code{sigma_hat} and the
quantiles by \code{q_hat}. Because a unimodal distribution is not
guaranteed, there is no estimator provided for the mode.

Method \code{distribution} returns the string representation 
of the expression used to create the model variable.
}
\references{
{
  Briggs A, Claxton K, Sculpher M. Decision modelling for health
  economic evaluation. Oxford, UK: Oxford University Press; 2006. 
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{ExprModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExprModVar$new()}}
\item \href{#method-add_method}{\code{ExprModVar$add_method()}}
\item \href{#method-is_probabilistic}{\code{ExprModVar$is_probabilistic()}}
\item \href{#method-operands}{\code{ExprModVar$operands()}}
\item \href{#method-distribution}{\code{ExprModVar$distribution()}}
\item \href{#method-r}{\code{ExprModVar$r()}}
\item \href{#method-mean}{\code{ExprModVar$mean()}}
\item \href{#method-mode}{\code{ExprModVar$mode()}}
\item \href{#method-SD}{\code{ExprModVar$SD()}}
\item \href{#method-quantile}{\code{ExprModVar$quantile()}}
\item \href{#method-mu_hat}{\code{ExprModVar$mu_hat()}}
\item \href{#method-sigma_hat}{\code{ExprModVar$sigma_hat()}}
\item \href{#method-q_hat}{\code{ExprModVar$q_hat()}}
\item \href{#method-set}{\code{ExprModVar$set()}}
\item \href{#method-get}{\code{ExprModVar$get()}}
\item \href{#method-clone}{\code{ExprModVar$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description">}\href{../../rdecision/html/ModVar.html#method-description}{\code{rdecision::ModVar$description()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression">}\href{../../rdecision/html/ModVar.html#method-is_expression}{\code{rdecision::ModVar$is_expression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units">}\href{../../rdecision/html/ModVar.html#method-units}{\code{rdecision::ModVar$units()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{ModVar} formed from an expression involving other
model variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$new(description, units, quo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{Name for the model variable expression. In 
a complex model it may help to tabulate how model variables are
combined into costs, probabilities and rates.}

\item{\code{units}}{Units in which the variable is expressed.}

\item{\code{quo}}{A \verb{quosure} (see package \pkg{rlang}), which contains an 
expression and its environment. The usage is \code{quo(x+y)} or 
\code{rlang::quo(x+y)}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of type \code{ExprModVar}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_method"></a>}}
\if{latex}{\out{\hypertarget{method-add_method}{}}}
\subsection{Method \code{add_method()}}{
Create a new \verb{quosure} from that supplied in \code{new()} but with
each \code{ModVar}
operand appended with \code{$x} where \code{x} is the argument to this
function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$add_method(method = "mean()")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{A character string with the method, e.g. \code{"mean()"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is mostly intended for internal use within the
class and will not generally be needed for normal use of
\code{ExprModVar} objects. The returned expression is \emph{not} 
syntactically checked or evaluated before it is returned.
}

\subsection{Returns}{
A \dfn{quosure} whose expression is each \code{ModVar} \code{v}
in the  
expression replaced with \code{v$method} and the same environment as
specified in the quosure supplied in new().
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, i.e. a random
variable that follows a distribution, or an expression involving
random variables, at least one of which follows a distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-operands"></a>}}
\if{latex}{\out{\hypertarget{method-operands}{}}}
\subsection{Method \code{operands()}}{
Return a list of operands that are themselves \code{ModVar}s given
in the expression.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$operands()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of model variables.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the expression model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expression as a character string with all control characters
having been removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-r"></a>}}
\if{latex}{\out{\hypertarget{method-r}{}}}
\subsection{Method \code{r()}}{
Draw a random sample from the model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$r(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of samples to draw.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A sample drawn at random.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the value of the expression when its operands take their
mean value (i.e. value returned by call to \code{mean} or their
value, if numeric). See notes on this class for further explanation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Mean value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the variable. By default returns \code{NA}, which 
will be the case for most \code{ExprModVar} variables, because an 
arbitrary expression is not guaranteed to be unimodal.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Mode as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution as \code{NA} because 
the variance is not available as a closed form for all functions of
distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Find quantiles of the uncertainty distribution.  Not available
as a closed form, and returned as \code{NA}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Numeric vector of probabilities, each in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of numeric values of the same length as \code{probs}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mu_hat"></a>}}
\if{latex}{\out{\hypertarget{method-mu_hat}{}}}
\subsection{Method \code{mu_hat()}}{
Return the estimated expected value of the expression variable. This is
computed by numerical simulation because there is, in general, no closed
form expressions for the mean of a function of distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$mu_hat(nest = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nest}}{Sample size to be used to estimate the mean. Values less than
1000 (default) are unlikely to return meaningful estimates and will 
be rejected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sigma_hat"></a>}}
\if{latex}{\out{\hypertarget{method-sigma_hat}{}}}
\subsection{Method \code{sigma_hat()}}{
Return the estimated standard deviation of the distribution. This is
computed by numerical simulation because there is, in general, no closed
form expressions for the SD of a function of distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$sigma_hat(nest = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nest}}{Sample size to be used to estimate the SD. Values less than
1000 (default) are unlikely to return meaningful estimates and will 
be rejected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Standard deviation as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-q_hat"></a>}}
\if{latex}{\out{\hypertarget{method-q_hat}{}}}
\subsection{Method \code{q_hat()}}{
Return the estimated quantiles by sampling the variable. This is
computed by numerical simulation because there is, in general, no closed
form expressions for the quantiles of a function of distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$q_hat(probs, nest = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Vector of probabilities, in range [0,1].}

\item{\code{nest}}{Sample size to be used to estimate the SD. Values less than
1000 (default) are unlikely to return meaningful estimates and will 
be rejected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of quantiles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\if{latex}{\out{\hypertarget{method-set}{}}}
\subsection{Method \code{set()}}{
Sets the value of the \code{ExprModVar} that will be returned by 
subsequent calls to \code{get()} until \code{set()} is called again. 
Because an \code{ExprModVar} can be considered as a dependent variable,
the idea of \code{set}ting a value is meaningless, and calls to this
method have no effect. To affect the
value returned by the next call to \code{get}, call \code{set} for each
of the operands of this expression.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$set(what = "random", val = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{Character string; for compatibility with non-expression
\code{ModVar}s only; not used.}

\item{\code{val}}{Numerical value when what="value"; not used for expression
model variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated \code{ExprModVar}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Gets the value of the \code{ExprModVar} that was set by the most recent
call to \code{set()} to each operand of the expression.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value determined by last \code{set()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
