% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{ddi_targetSampleSize}
\alias{ddi_targetSampleSize}
\alias{ddi_sampleSize}
\alias{ddi_sampleSizeFormula}
\title{targetSampleSize and its children nodes}
\usage{
ddi_targetSampleSize(...)

ddi_sampleSize(...)

ddi_sampleSizeFormula(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Provides both the target size of the sample (this is the number in the
original sample, not the number of respondents) as well as the formula used
for determining the sample size. More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{targetSampleSize} is contained in \code{dataColl}.

\emph{targetSampleSize specific child nodes}
\itemize{
\item \code{ddi_sampleSize()} provides the targeted sample size in integer format.
\item \code{ddi_sampleSizeFormula()} includes the formula that was used to determine
the sample size.
}
}
\examples{
ddi_targetSampleSize()

# Functions that need to be wrapped in ddi_targetSampleSize()

ddi_sampleSize(385)

ddi_sampleSizeFormula("n0=Z2pq/e2=(1.96)2(.5)(.5)/(.05)2=385 individuals")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/targetSampleSize.html}{targetSampleSize documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/sampleSize.html}{sampleSize documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/sampleSizeFormula.html}{sampleSizeFormula documentation}
}
