% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rddensity-package.R
\docType{package}
\name{rddensity-package}
\alias{rddensity-package}
\alias{_PACKAGE}
\title{rddensity: Manipulation Testing Based on Density Discontinuity}
\description{
Density discontinuity testing (a.k.a. manipulation testing) is commonly
  employed in regression discontinuity designs and other program evaluation settings
  to detect perfect self-selection (manipulation) around a cutoff where
  treatment/policy assignment changes.

This package implements manipulation testing procedures using the
  local polynomial density estimators proposed in Cattaneo, Jansson and Ma (2020a),
  and implements graphical procedures with valid confidence bands using the results
  in Cattaneo, Jansson and Ma (2020b,c).  In addition, this package provides complementary
  manipulation testing based on finite sample exact binomial testing following the
  esults in Cattaneo, Frandsen and Titiunik (2015) and Cattaneo, Frandsen and
  Vazquez-Bare (2017).

A companion \code{Stata} package is described in Cattaneo, Jansson and Ma (2018).

Commands: \code{\link{rddensity}} for manipulation (density discontinuity) testing.
  \code{\link{rdbwdensity}} for data-driven bandwidth selection, and
  \code{\link{rdplotdensity}} for density plots.

Related Stata and R packages useful for inference in regression discontinuity (RD)
  designs are described in the website: \url{https://sites.google.com/site/rdpackages}.
}
\references{
Calonico, S., M. D. Cattaneo, and M. H. Farrell. 2018. \href{https://sites.google.com/site/nppackages/nprobust/Calonico-Cattaneo-Farrell_2018_JASA.pdf}{On the Effect of Bias Estimation on Coverage Accuracy in Nonparametric Inference}. \emph{Journal of the American Statistical Association} 113(522): 767-779.

Calonico, S., M. D. Cattaneo, and M. H. Farrell. 2020. \href{http://sites.google.com/site/nppackages/nprobust/Calonico-Cattaneo-Farrell_2020_CEopt.pdf}{Coverage Error Optimal Confidence Intervals for Local Polynomial Regression}. Working paper.

Cattaneo, M. D., B. Frandsen, and R. Titiunik. 2015. \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Frandsen-Titiunik_2015_JCI.pdf}{Randomization Inference in the Regression Discontinuity Design: An Application to the Study of Party Advantages in the U.S. Senate.} \emph{Journal of Causal Inference} 3(1): 1-24.

Cattaneo, M. D., M. Jansson, and X. Ma. 2018. \href{https://sites.google.com/site/rdpackages/rddensity/Cattaneo-Jansson-Ma_2018_Stata.pdf}{Manipulation Testing based on Density Discontinuity}. \emph{Stata Journal} 18(1): 234-261.

Cattaneo, M. D., M. Jansson, and X. Ma. 2020a. \href{https://sites.google.com/site/rdpackages/rddensity/Cattaneo-Jansson-Ma_2020_JASA.pdf}{Simple Local Polynomial Density Estimators}. \emph{Journal of the American Statistical Association}, forthcoming.

Cattaneo, M. D., M. Jansson, and X. Ma. 2020b. \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2020_JoE.pdf}{Local Regression Distribution Estimators}. Working paper.

Cattaneo, M. D., M. Jansson, and X. Ma. 2020c. \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2020_JSS.pdf}{lpdensity: Local Polynomial Density Estimation and Inference}. Working paper.

Cattaneo, M. D., R. Titiunik and G. Vazquez-Bare. 2017. \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Titiunik-VazquezBare_2017_JPAM.pdf}{Comparing Inference Approaches for RD Designs: A Reexamination of the Effect of Head Start on Child Mortality}. \emph{Journal of Policy Analysis and Management} 36(3): 643-681.

McCrary, J. 2008. \href{https://doi.org/10.1016/j.jeconom.2007.05.005}{Manipulation of the Running Variable in the Regression Discontinuity Design: A Density Test}. \emph{Journal of Econometrics} 142(2): 698-714.
}
\author{
Matias D. Cattaneo, Princeton University  \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley.  \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
