% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_est.R
\name{mrd_est}
\alias{mrd_est}
\title{Multivariate Regression Discontinuity Estimation}
\usage{
mrd_est(
  formula,
  data,
  subset = NULL,
  cutpoint = NULL,
  bw = NULL,
  front.bw = NA,
  m = 10,
  k = 5,
  kernel = "triangular",
  se.type = "HC1",
  cluster = NULL,
  verbose = FALSE,
  less = FALSE,
  est.cov = FALSE,
  est.itt = FALSE,
  local = 0.15,
  ngrid = 250,
  margin = 0.03,
  boot = NULL,
  method = c("center", "univ", "front"),
  t.design = NULL,
  stop.on.error = TRUE
)
}
\arguments{
\item{formula}{The formula of the MRDD. This is supplied in the
format of \code{y ~ x1 + x2} for a simple sharp MRDD, or \code{y ~ x1 + x2 | c1 + c2}
for a sharp MRDD with two covariates. Fuzzy MRDD may be specified as
\code{y ~ x1 + x2 + z} where \code{x} is the running variable, and 
\code{z} is the endogenous treatment variable. Covariates are then included in the 
same manner as in a sharp MRDD.}

\item{data}{An optional data frame.}

\item{subset}{An optional vector specifying a subset of observations to be used.}

\item{cutpoint}{The cutpoint. If omitted, it is assumed to be c(0, 0).}

\item{bw}{A numeric vector specifying the bandwidths at which to estimate the RD. 
If omitted or it is \code{"IK12"}, the bandwidth is calculated using the Imbens-Kalyanaraman 
2012 method. If it is \code{"IK09"}, the bandwidth is calculated using 
the Imbens-Kalyanaraman 2009 method. Then it is estimated
with that bandwidth, half that bandwidth, and twice that bandwidth. 
If only a single value is passed into the function,
the RD will similarly be estimated at that bandwidth, half that bandwidth, 
and twice that bandwidth.}

\item{front.bw}{A numeric vector specifying the bandwidths at which to estimate the RD for each
of three effects models in the frontier method. If NA, front.bw will be determined by cross validation.}

\item{m}{The number of uniformly-at-random samples to draw as search candidates for front.bw 
if not given.}

\item{k}{An integer specifying the number of folds for cross validation to determine front.bw
if not given.}

\item{kernel}{A string specifying the kernel to be used in the local linear fitting. 
\code{"triangular"} kernel is the default and is the "correct" theoretical kernel to be 
used for edge estimation as in RDD (Lee and Lemieux, 2010). Other options are 
\code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, \code{"gaussian"} and \code{"cosine"}.}

\item{se.type}{This specifies the robust SE calculation method to use. Options are,
as in \code{\link{vcovHC}}, \code{"HC3"}, \code{"const"}, \code{"HC"}, \code{"HC0"}, 
\code{"HC1"}, \code{"HC2"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. This option 
is overridden by \code{cluster}.}

\item{cluster}{An optional vector specifying clusters within which the errors are assumed
to be correlated. This will result in reporting cluster robust SEs. This option overrides
anything specified in \code{se.type}. It is suggested that data with a discrete running 
variable be clustered by each unique value of the running variable (Lee and Card, 2008).}

\item{verbose}{Will provide some additional information printed to the terminal.}

\item{less}{Logical. If \code{TRUE}, return the estimates of linear and optimal, 
instead of linear, quadratic, cubic, optimal, half and double.}

\item{est.cov}{Logical. If \code{TRUE}, the estimates of covariates will be included. Not
applicable if method is \code{"front"}.}

\item{est.itt}{Logical. If \code{TRUE}, the estimates of ITT will be returned. Not
applicable if method is \code{"front"}.}

\item{local}{The range of neighboring points around the cutoff on the 
standardized scale on each assignment variable, which is a positive number.}

\item{ngrid}{The number of non-zero grid points on each assignment variable,
which is also the number of zero grid points on each assignment variable. Value used in 
Wong, Steiner and Cook (2013) is 2500, which may cause long computational time.}

\item{margin}{The range of grid points beyond the minimum and maximum
of sample points on each assignment variable.}

\item{boot}{The number of bootstrap samples to obtain standard error of estimates.}

\item{method}{The method to estimate rd effect. Options are \code{"center"}, 
\code{"univ"}, \code{"front"}.}

\item{t.design}{The treatment option according to design.
The 1st entry is for X1: \code{"g"} means treatment is assigned 
if X1 is greater than its cutoff, \code{"geq"} means treatment is assigned 
if X1 is greater than or equal to its cutoff, \code{"l"} means treatment is assigned 
if X1 is less than its cutoff, \code{"leq"} means treatment is assigned 
if X1 is less than or equal to its cutoff.
The 2nd entry is for X2.}

\item{stop.on.error}{Logical. If \code{TRUE} (the default), removes bootstraps which cause
error in the \code{integrate} function, and resample till the specified number of 
bootstrap samples are acquired.}
}
\value{
\code{mrd_est} returns an object of \link{class} "\code{mrd}".
}
\description{
\code{mrd_est} estimates treatment effects in an MRDD with two assignment variables, 
including the frontier average treatment effect (tau_MRD) 
and frontier-specific effects (tau_R and tau_M) simultaneously.
}
\examples{
x1 <- runif(1000, -1, 1)
x2 <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * (x1 >= 0) + 3 * cov + 10 * (x2 >= 0) + rnorm(1000)
# centering
mrd_est(y ~ x1 + x2 | cov, method = "center", t.design = c("geq", "geq"))
# univariate
mrd_est(y ~ x1 + x2 | cov, method = "univ", t.design = c("geq", "geq"))
# frontier
mrd_est(y ~ x1 + x2 | cov, method = "front", t.design = c("geq", "geq"))
}
\references{
Wong, V. C., Steiner, P. M., Cook, T. D. (2013). 
  Analyzing regression-discontinuity designs with multiple assignment variables: 
  A comparative study of four estimation methods.
  Journal of Educational and Behavioral Statistics, 38(2), 107-141.
  \url{http://journals.sagepub.com/doi/10.3102/1076998611432172}.
}
