% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_by_api_link.R
\name{rdb_by_api_link}
\alias{rdb_by_api_link}
\title{Download DBnomics data using API link.}
\usage{
rdb_by_api_link(api_link,
  use_readLines = getOption("rdbnomics.use_readLines"),
  curl_config = getOption("rdbnomics.curl_config"))
}
\arguments{
\item{api_link}{Character string. DBnomics API link of the search.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines} i.e.
through the default R internet connection. This can be used to get round the
error \code{Could not resolve host: api.db.nomics.world}.}

\item{curl_config}{Curl_handle or list (default \code{NULL}). If not
\code{NULL}, it is used to configure a proxy connection. This
configuration is passed to the function \code{curl_fetch_memory} of the package
\pkg{curl}. If it is a \code{curl_handle} object then it is considered to
be the argument \code{handle} of \code{curl_fetch_memory}. In the case of a
list, the names of the object are the arguments names of
\code{curl_fetch_memory} (except \code{url} of course). It means that
\code{curl_config = h} is equivalent to
\code{curl_config = list(handle = h)}. \cr
For \code{curl_fetch_memory} arguments see \code{\link[curl]{curl_fetch}}.
For available curl options see \code{\link[curl]{curl_options}},
\code{names(curl_options())} and
\href{https://curl.haxx.se/libcurl/c/curl_easy_setopt.html}{libcurl}.}
}
\value{
A \code{data.frame} or a \code{data.table}.
}
\description{
\code{rdb_by_api_link} downloads data series from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
This function gives you access to hundreds of millions data series from
\href{https://api.db.nomics.world/}{DBnomics API} (documentation about
the API can be found \href{https://api.db.nomics.world/v22/apidocs}{here}).
The API link is given on the
\href{https://db.nomics.world/}{DBnomics website}.
}
\examples{
\dontrun{
# Fetch two series from different datasets of different providers :
df1 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/',
    'series?observations=1&series_ids=AMECO/ZUTN/EA19.1.0.0.0.ZUTN,IMF/CPI/A.AT.PCPIT_IX'
  )
)

# Fetch one series from the dataset 'Doing Business' of WB provider :
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  )
)


## Use a specific proxy to fetch the data
# Fetch one series from the dataset 'Doing Business' of WB provider :
h <- curl::new_handle(
  proxy = "<proxy>",
  proxyport = <port>,
  proxyusername = "<username>",
  proxypassword = "<password>"
)
options(rdbnomics.curl_config = h)
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  )
)
# or to use once
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  ),
  curl_config = h
)


## Use R default connection to avoid a proxy failure (in some cases)
# Fetch one series from the dataset 'Doing Business' of WB provider :
options(rdbnomics.use_readLines = TRUE)
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  )
)
# or to use once
df2 <- rdb_by_api_link(
  paste0(
    'https://api.db.nomics.world/v22/series/WB/DB?dimensions=\%7B\%22',
    'indicator\%22\%3A\%5B\%22IC.REG.PROC.FE.NO\%22\%5D\%7D&q=Doing\%20Business',
    '&observations=1&format=json&align_periods=1&offset=0&facets=0'
  ),
  use_readLines = TRUE
)
}
}
\seealso{
\code{\link{rdb}}
}
