// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppArmadillo.h>
#include <Rcpp.h>

using namespace Rcpp;

// AcceleratedBellman
Rcpp::List AcceleratedBellman(const arma::mat& grid, Rcpp::NumericVector reward_, const arma::cube& scrap, Rcpp::NumericVector control_, const arma::cube& disturb, const arma::vec& weight, const std::size_t& n_neighbour, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_AcceleratedBellman(SEXP gridSEXP, SEXP reward_SEXP, SEXP scrapSEXP, SEXP control_SEXP, SEXP disturbSEXP, SEXP weightSEXP, SEXP n_neighbourSEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type reward_(reward_SEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type scrap(scrapSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type disturb(disturbSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type n_neighbour(n_neighbourSEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(AcceleratedBellman(grid, reward_, scrap, control_, disturb, weight, n_neighbour, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// AcceleratedExpected
arma::mat AcceleratedExpected(const arma::mat& grid, const arma::mat& value, const arma::cube& disturb, const arma::vec& weight, const std::size_t& n_neighbour, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_AcceleratedExpected(SEXP gridSEXP, SEXP valueSEXP, SEXP disturbSEXP, SEXP weightSEXP, SEXP n_neighbourSEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type value(valueSEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type disturb(disturbSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type n_neighbour(n_neighbourSEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(AcceleratedExpected(grid, value, disturb, weight, n_neighbour, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// AddDualBounds
Rcpp::List AddDualBounds(const arma::cube& path, Rcpp::NumericVector control_, Rcpp::Function Reward_, Rcpp::Function Scrap_, const arma::cube& mart, const arma::ucube& path_action);
RcppExport SEXP _rcss_AddDualBounds(SEXP pathSEXP, SEXP control_SEXP, SEXP Reward_SEXP, SEXP Scrap_SEXP, SEXP martSEXP, SEXP path_actionSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Reward_(Reward_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Scrap_(Scrap_SEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type mart(martSEXP);
    Rcpp::traits::input_parameter< const arma::ucube& >::type path_action(path_actionSEXP);
    rcpp_result_gen = Rcpp::wrap(AddDualBounds(path, control_, Reward_, Scrap_, mart, path_action));
    return rcpp_result_gen;
END_RCPP
}
// AddDual
arma::cube AddDual(const arma::cube& path, Rcpp::NumericVector subsim_, const arma::vec& weight, Rcpp::NumericVector value_, Rcpp::Function Scrap_);
RcppExport SEXP _rcss_AddDual(SEXP pathSEXP, SEXP subsim_SEXP, SEXP weightSEXP, SEXP value_SEXP, SEXP Scrap_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type subsim_(subsim_SEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type value_(value_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Scrap_(Scrap_SEXP);
    rcpp_result_gen = Rcpp::wrap(AddDual(path, subsim_, weight, value_, Scrap_));
    return rcpp_result_gen;
END_RCPP
}
// Expected
arma::mat Expected(const arma::mat& grid, const arma::mat& value, const arma::cube& disturb, const arma::vec& weight);
RcppExport SEXP _rcss_Expected(SEXP gridSEXP, SEXP valueSEXP, SEXP disturbSEXP, SEXP weightSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type value(valueSEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type disturb(disturbSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    rcpp_result_gen = Rcpp::wrap(Expected(grid, value, disturb, weight));
    return rcpp_result_gen;
END_RCPP
}
// Bellman
Rcpp::List Bellman(const arma::mat& grid, Rcpp::NumericVector reward_, const arma::cube& scrap, Rcpp::NumericVector control_, const arma::cube& disturb, const arma::vec& weight);
RcppExport SEXP _rcss_Bellman(SEXP gridSEXP, SEXP reward_SEXP, SEXP scrapSEXP, SEXP control_SEXP, SEXP disturbSEXP, SEXP weightSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type reward_(reward_SEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type scrap(scrapSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type disturb(disturbSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    rcpp_result_gen = Rcpp::wrap(Bellman(grid, reward_, scrap, control_, disturb, weight));
    return rcpp_result_gen;
END_RCPP
}
// FastAddDual
arma::cube FastAddDual(const arma::cube& path, Rcpp::NumericVector subsim_, const arma::vec& weight, const arma::mat& grid, Rcpp::NumericVector value_, Rcpp::Function Scrap_, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_FastAddDual(SEXP pathSEXP, SEXP subsim_SEXP, SEXP weightSEXP, SEXP gridSEXP, SEXP value_SEXP, SEXP Scrap_SEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type subsim_(subsim_SEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type value_(value_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Scrap_(Scrap_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(FastAddDual(path, subsim_, weight, grid, value_, Scrap_, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// FastBellman
Rcpp::List FastBellman(const arma::mat& grid, Rcpp::NumericVector reward_, const arma::cube& scrap, Rcpp::NumericVector control_, const arma::umat& r_index, const arma::cube& disturb, const arma::vec& weight, const std::size_t& n_smooth, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_FastBellman(SEXP gridSEXP, SEXP reward_SEXP, SEXP scrapSEXP, SEXP control_SEXP, SEXP r_indexSEXP, SEXP disturbSEXP, SEXP weightSEXP, SEXP n_smoothSEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type reward_(reward_SEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type scrap(scrapSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< const arma::umat& >::type r_index(r_indexSEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type disturb(disturbSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type n_smooth(n_smoothSEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(FastBellman(grid, reward_, scrap, control_, r_index, disturb, weight, n_smooth, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// FastExpected
arma::mat FastExpected(const arma::mat& grid, const arma::mat& value, const arma::umat& r_index, const arma::cube& disturb, const arma::vec& weight, const std::size_t& n_smooth, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_FastExpected(SEXP gridSEXP, SEXP valueSEXP, SEXP r_indexSEXP, SEXP disturbSEXP, SEXP weightSEXP, SEXP n_smoothSEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type value(valueSEXP);
    Rcpp::traits::input_parameter< const arma::umat& >::type r_index(r_indexSEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type disturb(disturbSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type weight(weightSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type n_smooth(n_smoothSEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(FastExpected(grid, value, r_index, disturb, weight, n_smooth, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// FiniteAddDual
arma::cube FiniteAddDual(const arma::cube& path, Rcpp::NumericVector path_disturb_, const arma::mat& grid, Rcpp::NumericVector value_, Rcpp::NumericVector expected_, const std::string& build, const std::size_t& k, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_FiniteAddDual(SEXP pathSEXP, SEXP path_disturb_SEXP, SEXP gridSEXP, SEXP value_SEXP, SEXP expected_SEXP, SEXP buildSEXP, SEXP kSEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type path_disturb_(path_disturb_SEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type value_(value_SEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type expected_(expected_SEXP);
    Rcpp::traits::input_parameter< const std::string& >::type build(buildSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type k(kSEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(FiniteAddDual(path, path_disturb_, grid, value_, expected_, build, k, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// PathDisturb
arma::cube PathDisturb(const arma::vec& start, Rcpp::NumericVector disturb_);
RcppExport SEXP _rcss_PathDisturb(SEXP startSEXP, SEXP disturb_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type start(startSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type disturb_(disturb_SEXP);
    rcpp_result_gen = Rcpp::wrap(PathDisturb(start, disturb_));
    return rcpp_result_gen;
END_RCPP
}
// PathPolicy
arma::ucube PathPolicy(const arma::cube& path, Rcpp::NumericVector control_, Rcpp::Function Reward_, Rcpp::NumericVector expected_);
RcppExport SEXP _rcss_PathPolicy(SEXP pathSEXP, SEXP control_SEXP, SEXP Reward_SEXP, SEXP expected_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Reward_(Reward_SEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type expected_(expected_SEXP);
    rcpp_result_gen = Rcpp::wrap(PathPolicy(path, control_, Reward_, expected_));
    return rcpp_result_gen;
END_RCPP
}
// FastPathPolicy
arma::ucube FastPathPolicy(const arma::cube& path, const arma::mat& grid, Rcpp::NumericVector control_, Rcpp::Function Reward_, Rcpp::NumericVector expected_, Rcpp::Function neighbour_);
RcppExport SEXP _rcss_FastPathPolicy(SEXP pathSEXP, SEXP gridSEXP, SEXP control_SEXP, SEXP Reward_SEXP, SEXP expected_SEXP, SEXP neighbour_SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Reward_(Reward_SEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type expected_(expected_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type neighbour_(neighbour_SEXP);
    rcpp_result_gen = Rcpp::wrap(FastPathPolicy(path, grid, control_, Reward_, expected_, neighbour_));
    return rcpp_result_gen;
END_RCPP
}
// Optimal
arma::mat Optimal(const arma::mat& grid, const arma::mat& subgradient);
RcppExport SEXP _rcss_Optimal(SEXP gridSEXP, SEXP subgradientSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::mat& >::type grid(gridSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type subgradient(subgradientSEXP);
    rcpp_result_gen = Rcpp::wrap(Optimal(grid, subgradient));
    return rcpp_result_gen;
END_RCPP
}
// StochasticGrid
arma::mat StochasticGrid(const arma::cube& path, const std::size_t& n_grid, const std::size_t& max_iter, const bool& warning);
RcppExport SEXP _rcss_StochasticGrid(SEXP pathSEXP, SEXP n_gridSEXP, SEXP max_iterSEXP, SEXP warningSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type n_grid(n_gridSEXP);
    Rcpp::traits::input_parameter< const std::size_t& >::type max_iter(max_iterSEXP);
    Rcpp::traits::input_parameter< const bool& >::type warning(warningSEXP);
    rcpp_result_gen = Rcpp::wrap(StochasticGrid(path, n_grid, max_iter, warning));
    return rcpp_result_gen;
END_RCPP
}
// TestPolicy
arma::vec TestPolicy(const std::size_t& start_position, const arma::cube& path, Rcpp::NumericVector control_, Rcpp::Function Reward_, Rcpp::Function Scrap_, const arma::ucube& path_action);
RcppExport SEXP _rcss_TestPolicy(SEXP start_positionSEXP, SEXP pathSEXP, SEXP control_SEXP, SEXP Reward_SEXP, SEXP Scrap_SEXP, SEXP path_actionSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const std::size_t& >::type start_position(start_positionSEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Reward_(Reward_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Scrap_(Scrap_SEXP);
    Rcpp::traits::input_parameter< const arma::ucube& >::type path_action(path_actionSEXP);
    rcpp_result_gen = Rcpp::wrap(TestPolicy(start_position, path, control_, Reward_, Scrap_, path_action));
    return rcpp_result_gen;
END_RCPP
}
// FullTestPolicy
Rcpp::List FullTestPolicy(const std::size_t& start_position, const arma::cube& path, Rcpp::NumericVector control_, Rcpp::Function Reward_, Rcpp::Function Scrap_, const arma::ucube& path_action);
RcppExport SEXP _rcss_FullTestPolicy(SEXP start_positionSEXP, SEXP pathSEXP, SEXP control_SEXP, SEXP Reward_SEXP, SEXP Scrap_SEXP, SEXP path_actionSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const std::size_t& >::type start_position(start_positionSEXP);
    Rcpp::traits::input_parameter< const arma::cube& >::type path(pathSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type control_(control_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Reward_(Reward_SEXP);
    Rcpp::traits::input_parameter< Rcpp::Function >::type Scrap_(Scrap_SEXP);
    Rcpp::traits::input_parameter< const arma::ucube& >::type path_action(path_actionSEXP);
    rcpp_result_gen = Rcpp::wrap(FullTestPolicy(start_position, path, control_, Reward_, Scrap_, path_action));
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_rcss_AcceleratedBellman", (DL_FUNC) &_rcss_AcceleratedBellman, 8},
    {"_rcss_AcceleratedExpected", (DL_FUNC) &_rcss_AcceleratedExpected, 6},
    {"_rcss_AddDualBounds", (DL_FUNC) &_rcss_AddDualBounds, 6},
    {"_rcss_AddDual", (DL_FUNC) &_rcss_AddDual, 5},
    {"_rcss_Expected", (DL_FUNC) &_rcss_Expected, 4},
    {"_rcss_Bellman", (DL_FUNC) &_rcss_Bellman, 6},
    {"_rcss_FastAddDual", (DL_FUNC) &_rcss_FastAddDual, 7},
    {"_rcss_FastBellman", (DL_FUNC) &_rcss_FastBellman, 9},
    {"_rcss_FastExpected", (DL_FUNC) &_rcss_FastExpected, 7},
    {"_rcss_FiniteAddDual", (DL_FUNC) &_rcss_FiniteAddDual, 8},
    {"_rcss_PathDisturb", (DL_FUNC) &_rcss_PathDisturb, 2},
    {"_rcss_PathPolicy", (DL_FUNC) &_rcss_PathPolicy, 4},
    {"_rcss_FastPathPolicy", (DL_FUNC) &_rcss_FastPathPolicy, 6},
    {"_rcss_Optimal", (DL_FUNC) &_rcss_Optimal, 2},
    {"_rcss_StochasticGrid", (DL_FUNC) &_rcss_StochasticGrid, 4},
    {"_rcss_TestPolicy", (DL_FUNC) &_rcss_TestPolicy, 6},
    {"_rcss_FullTestPolicy", (DL_FUNC) &_rcss_FullTestPolicy, 6},
    {NULL, NULL, 0}
};

RcppExport void R_init_rcss(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
