% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/near_repeat_analysis.R
\name{near_repeat_analysis}
\alias{near_repeat_analysis}
\title{Near Repeat Analysis of Crime Incidents with Crime Linkage Output}
\usage{
near_repeat_analysis(data, epsg, dist_thresh = NULL,
  time_thresh = NULL, tz = NULL)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}

\item{epsg}{The EPSG Geodetic Parameter code for the area being considered.
The EPSG code is used for identifying projections and performing coordinate
transformations. If needed, the EPSG for an area can be found at
\url{https://spatialreference.org}.}

\item{dist_thresh}{The spatial distance (in meters) which defines a near repeat
incident. By default this value is set to 1000 meters.}

\item{time_thresh}{The temporal distance (in days) which defines a near repeat
incident. By default this value is set to 7 days.}

\item{tz}{Time zone for which the area being examined. By default this value
is assigned as the same time zone of the system. For more information
about time zones within R, see \url{https://www.rdocumentation.org/packages/base/versions/3.6.1/topics/timezones}.}
}
\value{
Returns a list of all near repeat series identified within the input
    data as \pkg{igraph} graph objects. This list can be used to generate plots
    of each series and to discern the near repeat linkages between the crime
    incidents.
}
\description{
This function performs near repeat analysis for a set of incident
    locations. The user specifies distance and time thresholds which are utilized
    to search all other incidents and find other near repeat incidents. From this
    an adjacency matrix is created for incidents which are related under the
    thresholds. The adjacency matrix is then used to create an igraph graph which
    illustrates potentially related or linked incidents (under the near repeat
    thresholds).
}
\examples{
\dontshow{#' data(crimes)
nr_data <- head(crimes, n = 100)
out <- near_repeat_analysis(data=nr_data,tz="America/Chicago",epsg="32616")}
\donttest{data(crimes)
nr_data <- head(crimes, n = 1000) #truncate dataset for near repeat analysis
out <- near_repeat_analysis(data=nr_data,tz="America/Chicago",epsg="32616")}

}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{spatial}
