% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_functions.R
\name{key_functions}
\alias{key_functions}
\alias{show_default_rcreds_key_file}
\alias{create_key}
\alias{is.key_rcreds}
\alias{save_key}
\alias{read_key_from_file}
\title{Key Functions}
\usage{
show_default_rcreds_key_file()

create_key(bytes = 32, depth = 8, seed = NULL, showWarnings = TRUE,
  verbose = getOption("verbose.rcreds", default = TRUE))

is.key_rcreds(key)

save_key(file_full_path = file.path(folder, file_name),
  file_name = getOption("rcreds.key.file_name", default = ".crypt_key.rds"),
  folder = get_default_rcreds_key_folder(), key, bytes = 32, depth = 8,
  seed = NULL, zArchive_existing = TRUE, overwrite_existing = FALSE,
  showWarnings = TRUE, allow_root_user = FALSE,
  verbose = getOption("verbose.rcreds", default = TRUE))

read_key_from_file(file_full_path = file.path(folder, file_name),
  file_name = getOption("rcreds.key.file_name", default = ".crypt_key.rds"),
  folder = get_default_rcreds_key_folder(), create_if_not_exist = TRUE,
  showWarnings = FALSE, verbose = getOption("verbose.rcreds", default =
  TRUE))
}
\arguments{
\item{bytes}{Number of bytes used for the key.
             Values should normally be one of \code{c(16, 24, 32)}

             Defaults to: 32}

\item{depth}{Bit depth for key. 

             Defaults to: 8}

\item{seed}{An integer passed to \code{set.seed()} 
            Generating the key involves random number generation. Setting the seed will make the key determenistic. 

            Defaults to: NULL}

\item{showWarnings}{A TRUE/FALSE flag.  If FALSE, warnings will be silenced

                          Defaults to: TRUE}

\item{verbose}{A TRUE/FALSE flag.

               Defaults to: getOption(\\"verbose.rcreds\\", default = TRUE)}

\item{key}{A key object of class \code{"key_rcreds"} to be used for encrypting / decrypting. Passed to \code{digest::AES}.

                Alternatively, a full file path to a key stored on disk can be given which will be read to disk.}

\item{file_full_path}{The full path to the creds (or key) file, where it should be read from or written to. 
    if \code{"..auto.."} then will be constructed from \code{folder}, \code{file_name}, and \code{info.file_name}
    
    NOTE: When \code{file_full_path} is set explicitly, then \code{folder}, \code{file_name}, and \code{info.file_name} are ignored.

                      Defaults to: file.path(folder, file_name)}

\item{file_name}{name of the file where the key will be written to or read from.  Should be a string of length 1

                 Defaults to: getOption(\\"rcreds.key.file_name\\", default = \\".crypt_key.rds\\")}

\item{folder}{folder where the credentials will be written to or read from.

              Defaults to: get_default_rcreds_key_folder()}

\item{zArchive_existing}{A TRUE/FALSE flag.  If \code{file_full_path} already exist, should it be moved to a zArchive folder?

                         Defaults to: TRUE}

\item{overwrite_existing}{A TRUE/FALSE flag.  If \code{file_full_path} already exist, should it be overwritten? This is only considered when \code{zArchive_existing} is FALSE

                          Defaults to: FALSE}

\item{allow_root_user}{A TRUE/FALSE flag.  If FALSE and user is root, then writing and saving functions will fail
                    This is a safety to make sure the user understands they are operating under root.

                         Defaults to: FALSE}

\item{create_if_not_exist}{A TRUE/FALSE flag. for \code{read_key_from_file}: If the given file does not exist, 
                   should a key be created and stored at that location?

                   Defaults to: TRUE}
}
\value{
for \code{create_key} and \code{read_key_from_file}:  An object of class key_rcreds

    for \code{save_key} and \code{show_default_rcreds_key_file}:  A full file path. In the case of \code{save_key}, this is where the key has been written to.

    for \code{is.key_rcreds}:  A TRUE/FALSE value indidcating if the input is of class \code{"key_rcreds"}
}
\description{
ONE-LINER WHAT DO THESE GROUP OF FUNCS DO? (or the name of the main function)
}
\details{
DETAILED DESCRIPTION of what these functions do
}
\examples{

 \dontrun{
   ### ---------------------------------------------- ###
   ## Default Folders need to be set. This shold be in an .Rprofile file
   ### ---------------------------------------------- ###
   ## generally use:  set_default_rcreds_ALL(parent_folder = "~/.rcreds/")
   set_default_rcreds_ALL(parent_folder = file.path(tempdir(), ".rcreds/"), 
                          create_if_not_exist = TRUE)
   ### ---------------------------------------------- ###

   library(rcreds)

   key <- create_key()

   file_creds <- write_credentials_to_file(username="cosmo", password="too many secrets", key=key)
   file_key   <- save_key(folder="different/key/location")

   ### IN ANOTHER FILE
   key <- read_key_from_file(folder="different/key/location")
   creds <- read_credentials_from_file(key=key, fail_if_cant_decrypt=FALSE, showWarnings=FALSE)
   ## normally, leave the above flags as their default TRUE. Using FALSE for this example only.
 }

}
