% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{chi2CMB}
\alias{chi2CMB}
\title{Chi-squared statistic for two \code{\link{CMBWindow}}s}
\usage{
chi2CMB(cmbdf, win1, win2, intensities = "I")
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{win1}{A \code{\link{CMBWindow}}}

\item{win2}{A \code{\link{CMBWindow}}}

\item{intensities}{A \code{\link{CMBDataFrame}} column with measured values.}
}
\value{
Estimated Chi-squared statistic for observations in two
\code{\link{CMBWindow}}s.  For small sample sizes and many zero counts
Chi-squared statistic is inefficient.
}
\description{
This function returns the empirical chi-squared statistic for \code{intensities}
observations from two \code{\link{CMBWindow}}s of the specified
\code{\link{CMBDataFrame}}. The functions employs the function \link{chi2.empirical} and uses histogram
counts of \code{intensities} for computations.
}
\examples{
## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 1000)
#
# win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
# win2 <- CMBWindow(theta = c(pi/2,pi,pi/2),  phi = c(0,0,pi/2))
# plot(win1)
# plot(win2,col="green")
#
# chi2CMB(cmbdf, win1, win2)

}
\references{
\link{chi2.empirical}
}
