% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometry.R
\name{geoDist}
\alias{geoDist}
\title{Geodesic distance on the unit sphere}
\usage{
geoDist(p1, p2, include.names = FALSE)
}
\arguments{
\item{p1}{A \code{\link{data.frame}} with rows
specifying numeric points located on the unit sphere.
It should have columns labelled x,y,z
for Cartesian or theta, phi for spherical colatitude and
longitude respectively.}

\item{p2}{Same as p1.}

\item{include.names}{Boolean. If TRUE then the row and
column names of the returned matrix will be taken from
the points in \code{p1} and \code{p2} (see examples
below).}
}
\value{
Let \eqn{n} denote the number of rows of \code{p1}
and let \eqn{m} denote the number of rows of \code{p2}.
Then the returned object is an \eqn{n} by \eqn{m} matrix
whose entry in position \eqn{ij} is the geodesic distance
from the \eqn{i}th row of \code{p1} to the
\eqn{j}th row of \code{p2}.
}
\description{
Get geodesic distance between points on the unit sphere
}
\examples{

p1 <- data.frame(diag(3))
colnames(p1) <- c("x", "y", "z")
p1
p2 <- data.frame(x=c(1,0), y=c(0,3/5), z=c(0,4/5))
p2
geoDist(p1, p2, include.names = FALSE)

}
