% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{coords.HPDataFrame}
\alias{coords.HPDataFrame}
\title{Coordinate system from a \code{\link{HPDataFrame}}}
\usage{
\method{coords}{HPDataFrame}(x, new.coords, healpixCentered = FALSE, ...)
}
\arguments{
\item{x}{a HPDataFrame, \code{hpdf}.}

\item{new.coords}{specifies the new coordinate system
("spherical" or "cartesian")}

\item{healpixCentered}{boolean. If TRUE then columns x,y,z
or theta, phi will be ignored and removed if present.
This forces the coordinates to be found from HEALPix
pixel indices only. Then the HEALPixCentered
attribute of \code{hpdf} will be set to \code{TRUE}.}

\item{...}{Unused arguments.}
}
\value{
A \code{\link{HPDataFrame}} with columns x,y,z (cartesian)
or theta, phi (colatitude and longitude respectively)
}
\description{
Add or change coordinates in a \code{\link{HPDataFrame}}.
This does not affect the argument object \code{hpdf}.
Instead it returns a new \code{\link{HPDataFrame}}
with the desired coordinates. To change \code{hpdf}
directly see \code{\link{coords<-.HPDataFrame}}.
}
\details{
If columns exist labelled x,y,z (cartesian) or theta, phi
(colatitude and longitude respectively), then these will be
treated as the coordinates of \code{hpdf} and converted
accordingly.
If columns x,y,z or theta,phi are not present then the healpix
pixel indices as given by \code{pix(hpdf)} are used for
assigning coordinates.
}
\examples{
df <- HPDataFrame(I = rep(0,12), nside = 1)
coords(df, new.coords = "cartesian")
# Notice that df is unchanged
df

# Instead, change df directly
coords(df) <- "spherical"

## specify cartesian coordinates then convert to spherical
hp1 <- HPDataFrame(x = c(1,0,0), y = c(0,1,0), z = c(0,0,1),
                   nside = 1, auto.spix = TRUE)
hp1 <- coords(hp1, new.coords = "spherical")

## Instead, ignore/drop existing coordinates and use HEALPix only
hp2 <- HPDataFrame(x = c(1,0,0), y = c(0,1,0), z = c(0,0,1),
                   nside = 1, auto.spix = TRUE)
hp2 <- coords(hp1, new.coords = "spherical", healpixCentered = TRUE)

}
