% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_repos_search.R
\name{core_repos_search}
\alias{core_repos_search}
\title{Search CORE repositories}
\usage{
core_repos_search(query, page = 1, limit = 10, key = NULL,
  parse = TRUE, ...)
}
\arguments{
\item{query}{(character) query string, required}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10),
optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Search CORE repositories
}
\details{
\code{core_repos_search} does the HTTP request and parses, while
\code{core_repos_search_} just does the HTTP request, gives back JSON as
a character string

A POST method is allowed on this route, but it's not supported yet.
}
\examples{
\dontrun{
core_repos_search(query = 'mathematics')
core_repos_search(query = 'physics', parse = FALSE)
core_repos_search(query = 'pubmed')

core_repos_search_(query = 'pubmed')
library("jsonlite")
jsonlite::fromJSON(core_repos_search_(query = 'pubmed'))
}
}
\references{
\url{https://core.ac.uk/docs/#!/repositories/search}
}
