% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_parameters.trollsim.R
\name{update_parameters}
\alias{update_parameters}
\alias{update_parameters,trollsim-method}
\title{Update global parameters}
\usage{
update_parameters(sim, ...)

\S4method{update_parameters}{trollsim}(sim, ...)
}
\arguments{
\item{sim}{trollsim.}

\item{...}{parameters to update and their values (see \code{\link[=generate_parameters]{generate_parameters()}}
for a complete list).}
}
\value{
a \code{\link[=data.frame]{data.frame()}}
}
\description{
\code{update_parameters()} update the global parameters used in the \code{TROLL}
simulation from a TROLL outputs for a next simulation. All parameters have a
default value used in French Guiana simulations.
}
\examples{

data("TROLLv3_output")
head(update_parameters(TROLLv3_output, iters = 10))

}
\seealso{
\code{\link[=troll]{troll()}}, \code{\link[=stack]{stack()}}, \code{\link[=generate_parameters]{generate_parameters()}}
}
