% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_dependencies.R
\name{get_all_dependencies}
\alias{get_all_dependencies}
\title{Get all external dependencies}
\usage{
get_all_dependencies(pkg = NULL)
}
\arguments{
\item{pkg}{a character of length 1

The name of a CRAN package or \code{NULL} (default). If \code{NULL} get dependencies
of the local (uninstalled) project (package or compendium).}
}
\value{
A list of three vectors:
\itemize{
\item \code{base_deps}, a vector of base packages;
\item \code{direct_deps}, a vector of direct packages;
\item \code{all_deps}, a vector of all dependencies (recursively obtained).
}
}
\description{
This function gets all the external packages that the project needs. It is
used the generate the \emph{Dependencies} badge (\code{\link[=add_dependencies_badge]{add_dependencies_badge()}}).
}
\examples{
\dontrun{
## Update dependencies ----
add_dependencies()

## Get all dependencies ----
deps <- get_all_dependencies()
unlist(lapply(deps, length))

## Can be used for a CRAN package ----
deps <- get_all_dependencies("usethis")
unlist(lapply(deps, length))
}
}
\seealso{
Other utilities functions: 
\code{\link{get_all_functions}()},
\code{\link{get_licenses}()},
\code{\link{get_minimal_r_version}()}
}
\concept{utilities functions}
