% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_to_buildignore.R
\name{add_to_buildignore}
\alias{add_to_buildignore}
\title{Add to Rbuildignore file}
\usage{
add_to_buildignore(x, open = FALSE, quiet = FALSE)
}
\arguments{
\item{x}{a character vector

One or several files/directories names to be added to the \code{.Rbuildignore}.
This argument is mandatory.}

\item{open}{a logical value

If \code{TRUE} the \code{.Rbuildignore} file is opened in the editor.
Default is \code{FALSE}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function adds files/folders to the \code{.Rbuildignore} file. If a
\code{.Rbuildignore} is already present, files to be ignored while checking
package are just added to this file. Otherwise a new file is created.
}
\examples{
\dontrun{
add_to_buildignore(open = TRUE)
add_to_buildignore(".DS_Store")
}
}
\seealso{
Other development functions: 
\code{\link{add_dependencies}()},
\code{\link{add_github_actions_check}()},
\code{\link{add_github_actions_codecov}()},
\code{\link{add_github_actions_pkgdown}()},
\code{\link{add_r_depend}()},
\code{\link{add_to_gitignore}()}
}
\concept{development functions}
