% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countRSquare.r
\name{countRSquare}
\alias{countRSquare}
\title{Count pseudo r-squared for logistic and other binary outcome models}
\usage{
countRSquare(
  fit,
  digits = 3,
  suppressWarnings = TRUE,
  plotit = FALSE,
  jitter = FALSE,
  pch = 1,
  ...
)
}
\arguments{
\item{fit}{The fitted model object for which to determine pseudo r-squared.
\code{glm} and \code{glmmTMB} are supported.
Others may work as well.}

\item{digits}{The number of digits in the outputted values.}

\item{suppressWarnings}{If \code{TRUE}, suppresses warning messages.}

\item{plotit}{If \code{TRUE}, produces a simple plot of
actual vs. predicted values.}

\item{jitter}{If \code{TRUE}, jitters the "actual" values in the plot.}

\item{pch}{Passed to \code{plot}.}

\item{...}{Additional arguments.}
}
\value{
A list including a description of the submitted model,
        a data frame with the pseudo r-squared results,
        and a confusion matrix of the results.
}
\description{
Produces the count pseudo 
             r-squared measure for models with a binary outcome.
}
\details{
The count pseudo r-squared is simply the number of correctly
          predicted observations divided the total number of observations.
          
          This version is appropriate for models with a binary outcome.
          
          The adjusted value deducts the count of the most frequent
          outcome from both the numerator and the denominator.
          
          It is recommended that the model is fit on data in long
          format.  That is, that the \code{weight} option not be used in
          the model.
          
          The function makes no provisions for \code{NA} values.
          It is recommended that \code{NA} values be removed before
          the determination of the model.
}
\examples{
data(AndersonBias)

### Covert data to long format

Long = AndersonBias[rep(row.names(AndersonBias), AndersonBias$Count),
                    c("Result", "County", "Gender")]
rownames(Long) = seq(1:nrow(Long))
str(Long)

### Fit model and determine count r-square

model = glm(Result ~ County + Gender + County:Gender,
            data = Long,
            family = binomial())

countRSquare(model)

}
\references{
\url{https://stats.oarc.ucla.edu/other/mult-pkg/faq/general/faq-what-are-pseudo-r-squareds/},
            \url{https://rcompanion.org/handbook/H_08.html},
            \url{https://rcompanion.org/rcompanion/e_06.html}
}
\seealso{
\code{\link{nagelkerke}}, 
         \code{\link{efronRSquared}}, 
         \code{\link{accuracy}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{logistic regression}
\concept{pseudo r squared}
\concept{r squared}
