% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseNominalMatrix.r
\name{pairwiseNominalMatrix}
\alias{pairwiseNominalMatrix}
\title{Pairwise tests of independence for nominal data with matrix output}
\usage{
pairwiseNominalMatrix(
  x,
  compare = "row",
  fisher = TRUE,
  gtest = FALSE,
  chisq = FALSE,
  method = "fdr",
  correct = "none",
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A two-way contingency table. At least one dimension should have
more than two levels.}

\item{compare}{If \code{"row"}, treats the rows as the grouping variable.
If \code{"column"}, treats the columns as the grouping variable.}

\item{fisher}{If \code{"TRUE"}, conducts fisher exact test.}

\item{gtest}{If \code{"TRUE"}, conducts G-test.}

\item{chisq}{If \code{"TRUE"}, conducts Chi-square test of association.}

\item{method}{The method to adjust multiple p-values. 
See \code{\link{p.adjust}}.}

\item{correct}{The correction method to pass to \code{DescTools::GTest}.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments, passed to \code{stats::fisher.test}, 
\code{DescTools::GTest}, or \code{stats::chisq.test}.}
}
\value{
A list consisting of: the test used,
        a matrix of unadjusted p-values,
        the p-value adjustment method used,
        and a matrix of adjusted p-values.
}
\description{
Conducts pairwise tests for a 2-dimensional matrix,
             in which at at least one dimension has more than two
             levels, as a post-hoc test. Conducts Fisher exact, Chi-square,
             or G-test.
}
\examples{
### Independence test for a 4 x 2 matrix
data(Anderson)
fisher.test(Anderson)
Anderson = Anderson[(c("Heimlich", "Bloom", "Dougal", "Cobblestone")),]
PT = pairwiseNominalMatrix(Anderson,
                           fisher = TRUE,
                           gtest  = FALSE,
                           chisq  = FALSE)$Adjusted
PT
library(multcompView)
multcompLetters(PT)
                                                              
}
\references{
\url{http://rcompanion.org/handbook/H_04.html}
}
\seealso{
\code{\link{pairwiseMcnemar}}, 
         \code{\link{groupwiseCMH}},
         \code{\link{nominalSymmetryTest}}, 
         \code{\link{pairwiseNominalIndependence}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Fisher's exact test}
\concept{G test}
\concept{chi square test}
\concept{post-hoc}
