% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePercentileTest.r
\name{pairwisePercentileTest}
\alias{pairwisePercentileTest}
\title{Pairwise permutation tests for percentiles}
\usage{
pairwisePercentileTest(formula = NULL, data = NULL, x = NULL,
  y = NULL, test = "median", tau = 0.5, type = 7, threshold = NA,
  comparison = "<", r = 1000, digits = 4, progress = "TRUE",
  method = "fdr")
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable for one group.}

\item{y}{The response variable for the other group.}

\item{test}{The statistic to compare between groups.  Can be
\code{"median"}, \code{"percentile"}, \code{"iqr"},
\code{"proportion"},
\code{"mean"}, or \code{"variance"}.}

\item{tau}{If \code{"percentile"} is chosen as the \code{test},
\code{tau} indicates the percentile to test.  Expressed
as a quantile.  That is, 0.5 indicates a test for medians.
0.75 indicates a test for 75th percentiles.}

\item{type}{The \code{type} value passed to the \code{quantile} function.}

\item{threshold}{If \code{"proportion"} is chosen as the \code{test},
\code{threshold} indicates the value of the dependent variable
to use as the threshold.  For example, to test if there is a 
different in the proportion of observations below $10,000,
\code{threshold = 10000} would be used.}

\item{comparison}{If \code{"proportion"} is chosen as the \code{test},
\code{comparison} indicates the inequality to use.  Options are
\code{"<"}, \code{"<="}, \code{">"}, \code{">="}, or , \code{"=="}}

\item{r}{The number of replicates in the permutation test.}

\item{digits}{The number of significant digits in the output.}

\item{progress}{If \code{TRUE}, prints a dot for every 1 percent of the 
progress while conducting the test.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{stats::p.adjust}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Conducts pairwise permutation tests across groups 
             for percentiles, medians, and proportion below a
             threshold value.
}
\details{
The function conducts pairwise tests using the 
         \code{percentileTest} function. The user can consult the
         documentation for that function for additional details.
         
         The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{y}.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
\dontrun{
data(BrendonSmall)
PT = pairwisePercentileTest(Sodium ~ Instructor, 
                            data = BrendonSmall, 
                            test = "percentile", 
                            tau  = 0.75)
PT
cldList(p.adjust ~ Comparison,
        data       = PT,
        threshold  = 0.05)
        
data(BrendonSmall)
PT = pairwisePercentileTest(Sodium ~ Instructor, 
                            data       = BrendonSmall, 
                            test       = "proportion", 
                            threshold  = 1300)
PT
cldList(p.adjust ~ Comparison,
        data       = PT,
        threshold  = 0.05)                         
}

}
\references{
\url{http://rcompanion.org/handbook/F_15.html}
}
\seealso{
\code{\link{percentileTest}}, \code{\link{groupwisePercentile}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{median percentile quantile permutation}
