% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.r
\name{accuracy}
\alias{accuracy}
\title{Minimum maximum accuracy, mean absolute percent error, and root mean square error}
\usage{
accuracy(fits, plotit = TRUE, digits = 3, ...)
}
\arguments{
\item{fits}{A series of model object names. Must be a list.}

\item{plotit}{If \code{TRUE}, produces plots of the predicted values
vs. the actual values for each model.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Other arguments passed to \code{plot}.}
}
\value{
A list of two objects: The series of model calls, and a data 
        frame of statistics for each model.
}
\description{
Produces a table of fit statistics for multiple models.
}
\details{
Produces a table of fit statistics for multiple models: 
          minimum maximum accuracy, mean absolute percentage error,
          root mean square error, normalized root mean square error,
          and accuracy based on normalized root mean square error.
          
          For minimum maximum accuracy, larger indicates
          a better fit, 
          and a perfect fit is equal to 1.
          
          For mean absolute percent error (MAPE), smaller
          indicates a better fit,
          and a perfect fit is equal to 0.
          
          Root mean square error (RMSE) has the same units as the predicted
          values.
          
          Normalized root mean square error (NRMSE) is RMSE divided by
          the mean or the median of the values of the dependent variable. 
          
          NRMSE accuracy values are calculated as 1 minus
          NRMSE.  Like minimum maximum accuracy, larger indicates a
          better fit, and a perfect fit is equal to 1.
          
          Model objects currently supported: lm, glm, nls, betareg, gls,
          lmer, lmerTest, rq, loess, gam, glm.nb, glmRob.
}
\examples{
data(BrendonSmall)
BrendonSmall$Calories = as.numeric(BrendonSmall$Calories)
BrendonSmall$Calories2 = BrendonSmall$Calories ^ 2
model.1 = lm(Sodium ~ Calories, data = BrendonSmall)
model.2 = lm(Sodium ~ Calories + Calories2, data = BrendonSmall)
model.3 = glm(Sodium ~ Calories, data = BrendonSmall, family="Gamma")
quadplat = function(x, a, b, clx) {
          ifelse(x  < clx, a + b * x   + (-0.5*b/clx) * x   * x,
                           a + b * clx + (-0.5*b/clx) * clx * clx)}
model.4 = nls(Sodium ~ quadplat(Calories, a, b, clx),
              data = BrendonSmall,
              start = list(a=519, b=0.359, clx = 2300))
accuracy(list(model.1, model.2, model.3, model.4), plotit=FALSE)

}
\references{
\url{http://rcompanion.org/handbook/G_14.html}
}
\seealso{
\code{\link{compareLM}}, \code{\link{compareGLM}}, \code{\link{nagelkerke}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
accuracy mape r-squared
}
