#' @title Hypothetical data for paired ratings of Pooh Bear
#'
#' @description A data frame of Likert responses for instructor Pooh Bear
#'              for each of 10 respondents, paired before and after. 
#'              Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/F_06.html}
"Pooh"

###############################################################################

#' @title Hypothetical data for ratings of instructors in unreplicated CBD
#'
#' @description A data frame of Likert responses for five
#'              instructors for each of 8 respondents. 
#'              Arranged in unreplicated complete block design.
#'              Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/F_10.html}
"BobBelcher"

###############################################################################
#' @title Hypothetical data for responses about adopting lawn care practices
#'
#' @description A data frame in long form with yes/no responses for four
#'              lawn care practices for each of 14 respondents.
#'              Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/H_05.html}
"HayleySmith"

###############################################################################

#' @title Hypothetical data for change in religion after a caucausing event
#'
#' @description A matrix of paired counts for religion of people before 
#'              and after an event.
#'              Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/H_05.html}
"Religion"

###############################################################################

#' @title Hypothetical data for Alexander Anderson on rain barrel installation
#'
#' @description A matrix of paired counts for students planning to install rain
#'              barrels before and after a class. Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/H_05.html}
"AndersonRainBarrel"

###############################################################################

#' @title Hypothetical data for Alexander Anderson on rain garden installation
#'
#' @description A matrix of paired counts for students planning to install rain
#'              gardens before and after a class. Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/H_05.html}
"AndersonRainGarden"

###############################################################################

#' @title Hypothetical data for Alexander Anderson
#'
#' @description A matrix of counts for students passing or failing a pesticide 
#' training course across four counties. Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/H_04.html}
"Anderson"

###############################################################################

#' @title Hypothetical data for Alexander Anderson with sex bias
#'
#' @description A data frame of counts for students passing or failing a  
#' pesticicde training course across four counties, with sex of students. 
#' Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/H_06.html}
"AndersonBias"

###############################################################################

#' @title Hypothetical data for Brendon Small and company
#'
#' @description A data frame of intake of calories and sodium for students 
#'              in five classes. Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/I_10.html}
"BrendonSmall"

###############################################################################

#' @title Hypothetical data for Catbus and company
#'
#' @description A data frame of the number of steps taken by students in three
#'              classes. Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/C_03.html}
"Catbus"

###############################################################################

#' @title Hypothetical data for monarch butterflies in gardens
#'
#' @description A data frame of the number of monarch butterflies in three
#'              gardens. Hypothetical data.
#' 
#' @source \url{http://rcompanion.org/handbook/J_01.html}
"Monarchs"

###############################################################################

#' @title Data for proportion of good practices followed by plant nuseries
#'
#' @description A data frame with two variables: size of plant nursery in
#'              hectares, and proportion of good practices followed by
#'              the nursery
#' 
#' @source Mangiafico, S.S., Newman, J.P., Mochizuki, M.J.,
#'         and Zurawski, D. (2008). Adoption of sustainable practices
#'         to protect and conserve water resources in container nurseries
#'         with greenhouse facilities. Acta horticulturae 797, 367-372.
"Nurseries"

###############################################################################