% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.r
\name{icon}
\alias{icon}
\title{HTML code for icons.}
\usage{
icon(name)
}
\arguments{
\item{name}{string. name of the icon. You can see a full list of options at
\url{http://fontawesome.io/icons/}.}
}
\value{
string containing the HTML code.
}
\description{
Currently only supports Font Awesome
icons.
}
\note{
Requires the Font Awesome HTML code:
  \code{<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css">}
}
\examples{
rmd <- '
```{r}
library(rchallenge)
```
<link rel="stylesheet" 
 href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css">
`r icon("fa-user")`
`r icon("fa-user fa-lg")`
`r icon("fa-user fa-2x")`
`r icon("fa-user fa-3x")`
`r icon("fa-user fa-3x fa-border")`
'
file <- tempfile()
cat(rmd, file=file)
writeLines(readLines(file))
rmarkdown::render(file)
}
