/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.iupac.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.iupac.parser.AttachedGroup;
import org.openscience.cdk.iupac.parser.MoleculeBuilder;
import org.openscience.cdk.iupac.parser.NomParserConstants;
import org.openscience.cdk.iupac.parser.NomParserTokenManager;
import org.openscience.cdk.iupac.parser.ParseException;
import org.openscience.cdk.iupac.parser.SimpleCharStream;
import org.openscience.cdk.iupac.parser.Token;

public class NomParser
implements NomParserConstants {
    private static int mainChainPrefix;
    private static boolean isMainCyclic;
    private static List<Token> tempLocation;
    private static List<AttachedGroup> attachedGroups;
    private static List<AttachedGroup> attachedSubstituents;
    private static int currentNumber;
    public NomParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[29];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static IAtomContainer generate(String stringToParse) throws ParseException, CDKException {
        return NomParser.generate(stringToParse, DefaultChemObjectBuilder.getInstance());
    }

    public static IAtomContainer generate(String stringToParse, IChemObjectBuilder builder) throws ParseException, CDKException {
        isMainCyclic = false;
        tempLocation = new ArrayList<Token>();
        attachedSubstituents = new ArrayList<AttachedGroup>();
        attachedGroups = new ArrayList<AttachedGroup>();
        currentNumber = 0;
        StringReader stringReader = new StringReader(stringToParse.toLowerCase() + "\n");
        NomParser parser = new NomParser(stringReader);
        parser.completeChemicalName();
        NomParser.checkConnections(attachedSubstituents.iterator());
        NomParser.checkConnections(attachedGroups.iterator());
        MoleculeBuilder moleculeBuilder = new MoleculeBuilder(builder);
        IAtomContainer returnedMolecule = moleculeBuilder.buildMolecule(mainChainPrefix, attachedSubstituents, attachedGroups, isMainCyclic, stringToParse);
        return returnedMolecule;
    }

    private static void checkConnections(Iterator<AttachedGroup> vectorIterator) throws ParseException {
        while (vectorIterator.hasNext()) {
            AttachedGroup ag = vectorIterator.next();
            List<Token> locations = ag.getLocations();
            for (Token tok : locations) {
                try {
                    if (Integer.parseInt(tok.image) <= mainChainPrefix) continue;
                    String mesg = "invalid attachment point " + Integer.parseInt(tok.image) + " must be below " + (mainChainPrefix + 1);
                    throw new ParseException(mesg);
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
    }

    void AddHeadToken() throws ParseException {
        attachedSubstituents.add(new AttachedGroup(tempLocation, currentNumber));
        tempLocation = new Vector<Token>();
    }

    void MakeMainChainIntoSubstituent() throws ParseException {
        attachedSubstituents.add(new AttachedGroup(tempLocation, mainChainPrefix));
        currentNumber = 0;
        mainChainPrefix = 0;
        tempLocation = new Vector<Token>();
    }

    void AddFunGroup() throws ParseException {
        Token tok = this.getToken(-1);
        attachedGroups.add(new AttachedGroup(tempLocation, tok.image));
        tempLocation = new Vector<Token>();
    }

    void AddFunGroupPos() throws ParseException {
        Token tok = this.getToken(-1);
        tempLocation.add(tok);
    }

    void AddUnknownFunGroupPos() throws ParseException {
        Token tok = new Token();
        tok.image = "-1";
        tempLocation.add(tok);
    }

    void AddMainChain() throws ParseException {
        mainChainPrefix = currentNumber;
        currentNumber = 0;
    }

    void SetMainCyclic() throws ParseException {
        isMainCyclic = true;
    }

    public final void completeChemicalName() throws ParseException {
        if (this.jj_2_1(2)) {
            this.mainChainConstruct();
        } else {
            this.prefixConstruct();
            this.mainChainConstruct();
            this.jj_consume_token(1);
        }
    }

    public final void prefixConstruct() throws ParseException {
        this.prefixType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(4);
            this.prefixType();
        }
    }

    public final void prefixType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.attachLocationSpecified();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.AddUnknownFunGroupPos();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.subChain();
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: {
                this.functionalGroupPrefix();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void subChain() throws ParseException {
        this.chainPrefix();
        this.AddHeadToken();
        this.jj_consume_token(30);
    }

    public final void attachLocationSpecified() throws ParseException {
        this.jj_consume_token(2);
        this.AddFunGroupPos();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.oneAttachLocation();
                break;
            }
            case 5: {
                this.twoOrThreeAttachLocations();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void oneAttachLocation() throws ParseException {
        this.jj_consume_token(4);
    }

    public final void twoOrThreeAttachLocations() throws ParseException {
        this.jj_consume_token(5);
        this.jj_consume_token(2);
        this.AddFunGroupPos();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                this.jj_consume_token(31);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                this.jj_consume_token(2);
                this.AddFunGroupPos();
                this.jj_consume_token(4);
                this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void chainPrefix() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                this.specialCase();
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.allBaseNumbers();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: {
                                this.tensWithUnits();
                                break block0;
                            }
                            case 22: 
                            case 23: 
                            case 24: {
                                this.tensNoUnits();
                                break block0;
                            }
                        }
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void specialCase() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                currentNumber = 1;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                currentNumber = 2;
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                currentNumber = 3;
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                currentNumber = 4;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                currentNumber = 10;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                currentNumber = 11;
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                currentNumber = 20;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                currentNumber = 21;
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allBaseNumbers() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                currentNumber = 1;
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                currentNumber = 2;
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                currentNumber = 3;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                currentNumber = 4;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                currentNumber = 5;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                currentNumber = 6;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                currentNumber = 7;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                currentNumber = 8;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                currentNumber = 9;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void tensNoUnits() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                currentNumber += 10;
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                currentNumber += 20;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                currentNumber *= 10;
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void tensWithUnits() throws ParseException {
        int tempBackup = currentNumber;
        this.allBaseNumbers();
        this.jj_consume_token(24);
        currentNumber *= 10;
        currentNumber += tempBackup;
    }

    public final void functionalGroupPrefix() throws ParseException {
        this.prefixFunctionalGroups();
        this.AddFunGroup();
    }

    public final void mainChainConstruct() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.cycle();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.mainChainPrefix();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                this.AddUnknownFunGroupPos();
                this.MakeMainChainIntoSubstituent();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: {
                        this.prioritySubstituents();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        this.mainChainPrefix();
                        this.jj_consume_token(27);
                        this.prioritySubstituentsFunGroups();
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.AddUnknownFunGroupPos();
                this.AddFunGroup();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.bondType();
                this.mainChainSuffix();
            }
        }
    }

    public final void cycle() throws ParseException {
        this.jj_consume_token(32);
        this.SetMainCyclic();
    }

    public final void mainChainPrefix() throws ParseException {
        this.chainPrefix();
        this.AddMainChain();
    }

    public final void bondType() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                this.AddUnknownFunGroupPos();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        this.attachLocationSpecified();
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.AddUnknownFunGroupPos();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        break block0;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddFunGroup();
    }

    public final void mainChainSuffix() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.endFunctionalGroups();
                break;
            }
            case 4: 
            case 45: {
                this.connectingFunctionalGroupsConstruct();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void endFunctionalGroups() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddUnknownFunGroupPos();
        this.AddFunGroup();
    }

    public final void connectingFunctionalGroupsConstruct() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.connectingFunctionalGroupSuffix();
                this.AddUnknownFunGroupPos();
                break;
            }
            case 4: {
                this.jj_consume_token(4);
                this.attachLocationSpecified();
                this.connectingFunctionalGroupSuffix();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddFunGroup();
    }

    public final void connectingFunctionalGroupSuffix() throws ParseException {
        this.jj_consume_token(45);
    }

    public final void prefixFunctionalGroups() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void prioritySubstituentsFunGroups() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void prioritySubstituents() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                this.groupOneMetals();
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                this.groupTwoMetals();
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.dBlockMetals();
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                this.pBlockMetals();
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                this.fBlockMetals();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void groupOneMetals() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void groupTwoMetals() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void dBlockMetals() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void pBlockMetals() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void fBlockMetals() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 125: {
                this.jj_consume_token(125);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 129: {
                this.jj_consume_token(129);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            case 134: {
                this.jj_consume_token(134);
                break;
            }
            case 135: {
                this.jj_consume_token(135);
                break;
            }
            case 136: {
                this.jj_consume_token(136);
                break;
            }
            case 137: {
                this.jj_consume_token(137);
                break;
            }
            case 138: {
                this.jj_consume_token(138);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                break;
            }
            case 140: {
                this.jj_consume_token(140);
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_31() {
        return this.jj_3R_10();
    }

    private boolean jj_3R_7() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_8()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_4() {
        if (this.jj_3R_6()) {
            return true;
        }
        this.jj_la = 0;
        this.jj_scanpos = this.jj_lastpos;
        return false;
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_35()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_5() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        this.jj_la = 0;
        this.jj_scanpos = this.jj_lastpos;
        return false;
    }

    private boolean jj_3R_29() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_25() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_3() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3_1() {
        return this.jj_3R_2();
    }

    private boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_3()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_4();
    }

    private boolean jj_3R_20() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_22()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_23()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_24()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_25()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_26()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_27()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_28()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_8() {
        if (this.jj_3R_10()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_19() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_15() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_14()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_15()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_16()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_17()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_18()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_19()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_30() {
        return this.jj_3R_32();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{16, 4, 8388544, 48, 48, 33546240, 33546240, 8388544, 4202432, 4186112, 0x1C00000, 0, 8388544, 0x40000000, 16, 0x30000000, 0x8000000, 16, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 2558, 0, 0, 0, 0, 0, 0, 0, 0, 1, -4194304, 0, 0, 0, 0, 4124672, 65536, 4116480, 8192, 2558, 0x3C0000, -4194304, 0xFC00000, -268435456, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 3, -4, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 127, 1048448, -1048576};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65535, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65535, 0, 0, 0, 0, 65535};
    }

    public NomParser(InputStream stream) {
        this(stream, null);
    }

    public NomParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new NomParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public NomParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new NomParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public NomParser(NomParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(NomParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[144];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 29; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 144; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        NomParser.jj_la1_init_0();
        NomParser.jj_la1_init_1();
        NomParser.jj_la1_init_2();
        NomParser.jj_la1_init_3();
        NomParser.jj_la1_init_4();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

