/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLBuilder;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractFormula;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomArray;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Util;
import org.xmlcml.molutil.ChemicalElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLFormula
extends AbstractFormula {
    private static Logger LOG = Logger.getLogger(CMLFormula.class);
    public static final String SMILES = "SMILES";
    public static final String SMILES1 = "cml:smiles";
    public static final String NS = "cml:formula";
    public static final int NPLACES = 10;
    public static final int NDEC = 4;
    static Logger logger = Logger.getLogger(CMLFormula.class);
    private boolean processedConcise;
    private boolean allowNegativeCounts;

    public CMLFormula() {
        this.init();
    }

    public CMLFormula(CMLMolecule molecule) {
        this.init();
        int formalCharge = 0;
        for (CMLAtom atom : molecule.getAtoms()) {
            double occupancy = 1.0;
            if (atom.getOccupancyAttribute() != null) {
                occupancy = atom.getOccupancy();
            }
            if (occupancy <= 0.0) {
                throw new RuntimeException("zero or negative occupancy: " + occupancy);
            }
            String elementType = atom.getElementType();
            if (elementType == null || ChemicalElement.getChemicalElement(elementType) == null) {
                throw new RuntimeException("Missing or invalid elementType for atom : " + atom.getId() + " .. " + elementType);
            }
            if (!ChemicalElement.AS.H.equals(elementType)) {
                int hydrogenCount;
                this.add(elementType, 1.0);
                if (atom.getFormalChargeAttribute() != null) {
                    formalCharge += atom.getFormalCharge();
                }
                if ((hydrogenCount = atom.getHydrogenCount()) <= 0) continue;
                this.add(ChemicalElement.AS.H.value, hydrogenCount);
                continue;
            }
            List<CMLAtom> oatoms = atom.getLigandAtoms();
            boolean countit = true;
            for (CMLAtom chk : oatoms) {
                String ctype = chk.getElementType();
                if (ChemicalElement.AS.H.equals(ctype)) continue;
                countit = false;
            }
            if (!countit) continue;
            this.add(ChemicalElement.AS.H.value, 1.0);
            if (atom.getFormalChargeAttribute() == null) continue;
            formalCharge += atom.getFormalCharge();
        }
        if (formalCharge != Integer.MIN_VALUE) {
            this.setFormalCharge(formalCharge);
        } else if (molecule.getFormalChargeAttribute() != null) {
            this.setFormalCharge(molecule.getFormalCharge());
        }
    }

    public CMLFormula(CMLFormula old) {
        this();
        this.copyAttributesFrom(old);
        CMLAtomArray newAtomArray = this.getAtomArrayElements().get(0);
        if (newAtomArray != null) {
            this.removeChild(newAtomArray);
        }
        this.copyChildrenFrom(old);
        this.copyProperties(old);
    }

    public void detachAllAtomArraysAsTheyAreAMenace() {
        CMLElements<CMLAtomArray> atomArrays = this.getAtomArrayElements();
        for (CMLAtomArray atomArray : atomArrays) {
            atomArray.detach();
        }
    }

    @Override
    public Node copy() {
        CMLFormula newForm = new CMLFormula(this);
        return newForm;
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLFormula();
    }

    @Override
    public void finishMakingElement(Element parent) {
        super.finishMakingElement(parent);
    }

    public void normalize() {
        CMLAttribute conciseAtt = this.getConciseAttribute();
        int formalCharge = 0;
        if (this.getFormalChargeAttribute() != null) {
            formalCharge = this.getFormalCharge();
        }
        String conciseS = conciseAtt == null ? null : conciseAtt.getValue();
        String convention = this.getConvention();
        String inline = this.getInline();
        if (inline != null) {
            inline = inline.trim();
        }
        Nodes texts = this.query("text()");
        String content = null;
        for (int i = 0; i < texts.size(); ++i) {
            Text text = (Text)texts.get(i);
            String s = text.getValue();
            if ((s = s.trim()).length() == 0) continue;
            if (content == null) {
                content = s;
                continue;
            }
            throw new RuntimeException("Cannot have 2 non-empty text children");
        }
        String atomArray2Concise = null;
        CMLAtomArray atomArray = null;
        CMLElements<CMLAtomArray> atomArrays = this.getAtomArrayElements();
        if (atomArrays.size() > 1) {
            throw new RuntimeException("Only one atomArray child allowed for formula; found: " + atomArrays.size());
        }
        if (atomArrays.size() == 1) {
            atomArray = atomArrays.get(0);
            atomArray.sort(Sort.CHFIRST);
            atomArray2Concise = atomArray.generateConcise(formalCharge);
        }
        if (content != null) {
            if (inline == null || inline.equals("")) {
                this.setInline(content);
                for (int i = 0; i < texts.size(); ++i) {
                    texts.get(i).detach();
                }
            } else if (!inline.equals(content)) {
                throw new RuntimeException("inline (" + inline + ") differs from content (" + content + ")");
            }
        }
        if (inline == null || SMILES.equals(convention) || SMILES1.equals(convention)) {
            // empty if block
        }
        if (conciseS == null && atomArray2Concise != null) {
            conciseS = atomArray2Concise;
        }
        if (conciseS != null) {
            conciseS = this.normalizeConciseAndFormalCharge(conciseS, formalCharge);
        }
        if (atomArray != null) {
            this.checkAtomArrayFormat(atomArray);
        }
        if (atomArray != null) {
            atomArray.sort(Sort.CHFIRST);
            this.removeZeroAtomCounts();
        }
        if (atomArray2Concise != null && !atomArray2Concise.equals(conciseS)) {
            throw new RuntimeException("concise (" + conciseS + ") and atomArray (" + atomArray2Concise + ") differ");
        }
        if (conciseS != null) {
            conciseS = this.normalizeConciseAndFormalCharge(conciseS, this.getFormalCharge());
            super.setConcise(conciseS);
        }
    }

    private void removeZeroAtomCounts() {
    }

    public static Element getSubscriptedConcise(String concise) {
        Element element = new Element("span");
        if (concise != null) {
            String[] split = concise.split(" ");
            int len = split.length;
            int n = len / 2;
            for (int j = 0; j < 2 * n; j += 2) {
                element.appendChild(split[j]);
                if (split[j + 1].equals("1")) continue;
                Element sub = new Element("sub");
                sub.appendChild(split[j + 1]);
                element.appendChild(sub);
            }
            if (len % 2 != 0) {
                element.appendChild(split[len - 1]);
            }
        }
        return element;
    }

    CMLAtomArray createAndAddAtomArrayAndFormalChargeFromConcise(String concise) {
        CMLAtomArray atomArray = new CMLAtomArray();
        if (concise != null) {
            ArrayList<String> elements = new ArrayList<String>();
            ArrayList<Double> counts = new ArrayList<Double>();
            String[] tokens = concise.split("\\s+");
            int nelement = tokens.length / 2;
            for (int i = 0; i < nelement; ++i) {
                String elem = tokens[2 * i];
                ChemicalElement chemicalElement = ChemicalElement.getChemicalElement(elem);
                if (chemicalElement == null) {
                    throw new RuntimeException("Unknown chemical element: " + elem);
                }
                if (elements.contains(elem)) {
                    throw new RuntimeException("Duplicate element in concise: " + elem);
                }
                elements.add(elem);
                String countS = tokens[2 * i + 1];
                try {
                    counts.add(new Double(countS));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad element count in concise: " + countS);
                }
            }
            if (tokens.length > nelement * 2) {
                String chargeS = tokens[nelement * 2];
                try {
                    int formalCharge = Integer.parseInt(chargeS);
                    super.setFormalCharge(formalCharge);
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad formal charge in concise: " + chargeS);
                }
            }
            double[] countD = new double[nelement];
            for (int i = 0; i < nelement; ++i) {
                countD[i] = (Double)counts.get(i);
            }
            atomArray.setElementTypeAndCount(elements.toArray(new String[0]), countD);
        }
        this.setAtomArray(atomArray);
        return atomArray;
    }

    private void setAtomArray(CMLAtomArray atomArray) {
        for (CMLAtomArray aa : this.getAtomArrayElements()) {
            aa.detach();
        }
        super.appendChild(atomArray);
    }

    public void checkAtomArrayFormat(CMLAtomArray atomArray) {
        if (atomArray.getChildElements().size() > 0) {
            throw new RuntimeException("No children allowed for formula/atomArray");
        }
        String[] elements = atomArray.getElementType();
        double[] counts = atomArray.getCount();
        if (elements == null || counts == null) {
            throw new RuntimeException("formula/atomArray must have elementType and count attributes");
        }
        if (elements.length != counts.length) {
            throw new RuntimeException("formula/atomArray must have equal length elementType and count values");
        }
        HashSet<String> elementSet = new HashSet<String>();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null || elements[i].equals("null")) continue;
            if (elementSet.contains(elements[i])) {
                throw new RuntimeException("formula/atomArray@elementType has duplicate element: " + elements[i]);
            }
            elementSet.add(elements[i]);
            if (!(counts[i] <= 0.0) || this.allowNegativeCounts) continue;
            throw new RuntimeException("formula/atomArray@count has nonPositive value: " + counts[i] + "  " + elements[i]);
        }
    }

    public void appendChild(Element child) {
        if (child instanceof CMLAtomArray) {
            throw new RuntimeException("atomArray child of formula is deprecated");
        }
        super.appendChild(child);
    }

    public static String removeChargeFromConcise(String s) {
        String s0 = s.trim();
        String[] ss = s0.split(" ");
        if (ss.length % 2 != 0) {
            int idx = s0.lastIndexOf(" ");
            s0 = s0.substring(0, idx).trim();
        }
        return s0;
    }

    public String getConciseNoCharge() {
        String concise = this.getConcise();
        return concise == null ? null : CMLFormula.removeChargeFromConcise(concise);
    }

    public static String getCompactedConcise(String concise) {
        return CMLFormula.getCompactedConcise(concise, false);
    }

    public static String getCompactedConcise(String concise, boolean html) {
        String s = "";
        if (concise != null) {
            String[] split = concise.split(" ");
            int n = split.length / 2;
            for (int j = 0; j < 2 * n; j += 2) {
                s = s + split[j];
                if (split[j + 1].equals("1")) continue;
                if (html) {
                    s = s + "<sub>";
                }
                s = s + split[j + 1];
                if (!html) continue;
                s = s + "</sub>";
            }
            if (split.length % 2 != 0) {
                if (html) {
                    s = s + "<sup>";
                }
                s = s + CMLFormula.makeCharge(split[split.length - 1]);
                if (html) {
                    s = s + "</sup>";
                }
            }
        }
        return s;
    }

    private static String makeCharge(String ss) {
        int i = Integer.parseInt(ss);
        String s = i < 0 ? "-" : "+";
        if ((i = Math.abs(i)) > 1) {
            s = s + i;
        }
        return s;
    }

    @Override
    public void setConcise(String value) throws RuntimeException {
        if (this.getAtomArrayElements().size() > 0) {
            throw new RuntimeException("Cannot reset concise if atomArray is present");
        }
        this.forceConcise(value);
    }

    private void forceConcise(String value) {
        super.setConcise(value);
        this.normalize();
        this.processedConcise = true;
    }

    private String normalizeConciseAndFormalCharge(String conciseS, int formalCharge) {
        CMLAtomArray atomArray;
        if (conciseS != null && (atomArray = this.createAndAddAtomArrayAndFormalChargeFromConcise(conciseS)) != null) {
            atomArray.sort(Sort.CHFIRST);
            conciseS = atomArray.generateConcise(formalCharge);
        }
        return conciseS;
    }

    @Override
    public void setFormalCharge(int ch) {
        super.setFormalCharge(ch);
        if (this.getConciseAttribute() != null) {
            String concise = this.getConcise();
            concise = CMLFormula.removeChargeFromConcise(concise);
            this.forceConcise(concise);
        }
        this.normalize();
    }

    void init() {
        this.processedConcise = false;
    }

    public static CMLFormula createFormula(String s) {
        return CMLFormula.createFormula(s, Type.ANY);
    }

    public static CMLFormula createFormula(CMLMolecule mol) {
        if (mol == null) {
            return null;
        }
        return new CMLFormula(mol);
    }

    public static CMLFormula createFormula(String s, boolean allowNegativeCounts) {
        return CMLFormula.createFormula(s, Type.ANY, allowNegativeCounts);
    }

    public static CMLFormula createFormula(String s, Type convention) {
        CMLFormula docFormula = new CMLFormula();
        if (s != null && !s.equals("")) {
            docFormula.createFromString(s, convention);
        } else {
            docFormula = null;
        }
        return docFormula;
    }

    public static CMLFormula createFormula(String s, Type convention, boolean allowNegativeCounts) {
        CMLFormula docFormula = new CMLFormula();
        docFormula.setAllowNegativeCounts(allowNegativeCounts);
        docFormula.createFromString(s, convention);
        return docFormula;
    }

    void createFromString(String formulaString, Type formulaConvention) {
        formulaString = formulaString.trim();
        if (formulaConvention.equals((Object)Type.ELEMENT_WHITESPACE_COUNT) || formulaConvention.equals((Object)Type.ELEMENT_COUNT_WHITESPACE)) {
            this.parseElementCountWhitespace(formulaString, formulaConvention);
        } else if (formulaConvention.equals((Object)Type.NOPUNCTUATION)) {
            this.parseAny(formulaString);
        } else if (formulaConvention.equals((Object)Type.MULTIPLIED_ELEMENT_COUNT_WHITESPACE)) {
            this.parseMultipliedElementCountWhitespace(formulaString);
        } else if (formulaConvention.equals((Object)Type.MOIETY)) {
            this.parseMoiety(formulaString);
        } else if (formulaConvention.equals((Object)Type.SUBMOIETY)) {
            this.parseSubMoiety(formulaString);
        } else if (formulaConvention.equals((Object)Type.IUPAC)) {
            LOG.warn("IUPAC formula convention not yet supported");
        } else if (formulaConvention.equals((Object)Type.NESTEDBRACKETS) || formulaConvention.equals((Object)Type.STRUCTURAL)) {
            LOG.debug("Nested/structural formula convention not yet supported");
        } else if (formulaConvention.equals((Object)Type.CONCISE)) {
            this.setConcise(formulaString);
        } else if (formulaConvention.equals((Object)Type.ANY)) {
            this.parseAny(formulaString);
        } else {
            throw new RuntimeException("Unknown formula convention: " + formulaConvention.type);
        }
    }

    private void parseElementCountWhitespace(String formulaString, Type formulaConvention) {
        StringTokenizer st = new StringTokenizer(formulaString);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            String countS = null;
            String elTypeS = null;
            if (formulaConvention.equals((Object)Type.ELEMENT_WHITESPACE_COUNT)) {
                try {
                    countS = st.nextToken();
                }
                catch (NoSuchElementException e) {
                    throw new RuntimeException("Bad formula: {" + formulaString + "}");
                }
                elTypeS = s;
            } else {
                elTypeS = "";
                int l = s.length();
                if (!Character.isUpperCase(s.charAt(0))) {
                    throw new RuntimeException("Bad element 1st char in: " + s);
                }
                if (l == 1) {
                    elTypeS = s;
                    countS = "1";
                } else if (Character.isLowerCase(s.charAt(1))) {
                    elTypeS = s.substring(0, 2);
                    countS = s.substring(2);
                } else {
                    elTypeS = s.substring(0, 1);
                    countS = s.substring(1);
                }
            }
            double c = 0.0;
            ChemicalElement element = ChemicalElement.getChemicalElement(elTypeS);
            if (element == null) {
                throw new RuntimeException("Bad element (" + elTypeS + ") in: " + s);
            }
            if (countS.equals("")) {
                c = 1.0;
            } else {
                try {
                    c = new Double(countS);
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad element count (" + countS + ") in: " + s);
                }
            }
            this.add(elTypeS, c);
        }
        String concise = this.getFormattedString(Type.ELEMENT_WHITESPACE_COUNT, Sort.CHFIRST, false).trim();
        if (!concise.equals("")) {
            super.setConcise(concise);
        }
    }

    private void parseMultipliedElementCountWhitespace(String formulaString) {
        int ii;
        formulaString.trim();
        double mult = -1.0;
        for (ii = 0; ii < formulaString.length() && (formulaString.charAt(ii) == '.' || Character.isDigit(formulaString.charAt(ii))); ++ii) {
        }
        if (ii != 0) {
            try {
                mult = new Double(formulaString.substring(0, ii));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Cannot interpret start of formula as multiplier: " + formulaString);
            }
            formulaString = formulaString.substring(ii);
        }
        int lb = formulaString.indexOf("(");
        int rb = formulaString.indexOf(")");
        if (lb == -1 && rb == -1) {
            this.createFromString(formulaString, Type.ANY);
        } else if (lb == 0 && rb != -1) {
            if (mult < 0.0) {
                String r = formulaString.substring(rb + 1);
                if (r.length() > 0) {
                    try {
                        mult = new Double(r);
                    }
                    catch (NumberFormatException nfe) {
                        throw new RuntimeException("Bad multiplier in: " + formulaString);
                    }
                } else {
                    mult = 1.0;
                }
            }
            this.createFromString(formulaString.substring(1, rb), Type.ANY);
        } else {
            throw new RuntimeException("Unbalanced () in multiplied formula string: " + formulaString);
        }
        if (mult > 0.0) {
            this.setCount(mult);
        }
    }

    private void parseMoiety(String formulaString) {
        StringTokenizer st = new StringTokenizer(formulaString = formulaString.trim(), ",");
        if (st.countTokens() == 1) {
            this.parseMoiety0(formulaString);
        } else {
            while (st.hasMoreTokens()) {
                CMLFormula subForm = new CMLFormula();
                String f = st.nextToken().trim();
                subForm.parseMoiety0(f);
                this.appendChild(subForm);
            }
        }
    }

    private void parseMoiety0(String formulaString) {
        int ii;
        formulaString = formulaString.trim();
        double mult = -1.0;
        for (ii = 0; ii < formulaString.length() && (formulaString.charAt(ii) == '.' || Character.isDigit(formulaString.charAt(ii))); ++ii) {
        }
        if (ii != 0) {
            try {
                mult = new Double(formulaString.substring(0, ii));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Cannot interpret start of formula as multiplier: " + formulaString);
            }
            formulaString = formulaString.substring(ii);
        }
        int lb = formulaString.indexOf("(");
        int rb = formulaString.indexOf(")");
        if (lb == -1 && rb == -1) {
            this.parseSubMoiety(formulaString);
        } else if (lb == 0 && rb != -1) {
            if (mult < 0.0) {
                String r = formulaString.substring(rb + 1);
                if (r.length() > 0) {
                    try {
                        mult = new Double(r);
                    }
                    catch (NumberFormatException nfe) {
                        throw new RuntimeException("Bad multiplier in: " + formulaString);
                    }
                } else {
                    mult = 1.0;
                }
            }
            this.parseSubMoiety(formulaString.substring(1, rb));
        } else {
            throw new RuntimeException("Unbalanced () in multiplied formula string: " + formulaString);
        }
        if (mult > 0.0) {
            this.setCount(mult);
        }
    }

    private void parseSubMoiety(String sm) {
        sm = sm.trim();
        int charge = 0;
        StringTokenizer st = new StringTokenizer(sm);
        int l = st.countTokens();
        for (int i = 0; i < l; ++i) {
            String ss;
            String s = ss = st.nextToken();
            int mult = 0;
            if (i == l - 1) {
                char c = s.charAt(0);
                if (c == '+') {
                    mult = 1;
                    s = s.substring(1);
                } else if (c == '-') {
                    mult = -1;
                    s = s.substring(1);
                } else if (s.endsWith("+")) {
                    mult = 1;
                    s = s.substring(0, s.length() - 1);
                } else if (s.endsWith("-")) {
                    mult = -1;
                    s = s.substring(0, s.length() - 1);
                }
                if (mult != 0) {
                    if (!s.trim().equals("")) {
                        try {
                            charge = Integer.parseInt(s);
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("Bad charge: " + s);
                        }
                    } else {
                        charge = 1;
                    }
                    charge *= mult;
                }
            }
            if (mult != 0) break;
            s = ss;
            String elem = "";
            double count = 0.0;
            if (Character.isUpperCase(s.charAt(0))) {
                if (s.length() > 1) {
                    if (Character.isLowerCase(s.charAt(1))) {
                        elem = s.substring(0, 2);
                        s = s.substring(2);
                    } else {
                        if (!Character.isDigit(s.charAt(1))) {
                            throw new RuntimeException("Bad elementCount: " + s);
                        }
                        elem = s.substring(0, 1);
                        s = s.substring(1);
                    }
                    if (s.trim().equals("")) {
                        count = 1.0;
                    } else {
                        try {
                            count = new Double(s);
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("Moiety cannot parse element count: " + s);
                        }
                    }
                } else {
                    elem = s;
                    count = 1.0;
                }
            } else {
                throw new RuntimeException("Moiety cannot parse element at: " + s);
            }
            if (elem.equals("")) {
                throw new RuntimeException("Moiety cannot parse element: " + s);
            }
            ChemicalElement element = ChemicalElement.getChemicalElement(elem);
            if (element == null) {
                throw new RuntimeException("Bad element (" + elem + ") in: " + elem);
            }
            this.add(elem, count);
        }
        if (charge != 0) {
            this.setFormalCharge(charge);
        }
    }

    private void parseAny(String formulString) {
        StringBuilder result = new StringBuilder();
        String ss = formulString.trim();
        int l = ss.length();
        int i = 0;
        int ii = 0;
        int charge = 0;
        while (i < l && (i = this.grabWhite(ss, i, l)) < l) {
            result.append(" ");
            ii = this.grabElement(ss, i, l);
            if (ii == i) {
                ii = this.grabCharge(ss, i, l);
                if (ii == i) break;
                charge = CMLFormula.parseCharge(ss.substring(i, ii));
                break;
            }
            result.append(ss.substring(i, ii));
            result.append(" ");
            i = ii;
            i = this.grabWhite(ss, i, l);
            ii = this.grabCount(ss, i, l);
            if (ii == i) {
                result.append(1);
            } else {
                result.append(ss.substring(i, ii));
            }
            i = ii;
            i = this.grabWhite(ss, i, l);
        }
        String sss = result.toString().trim();
        this.createFromString(sss, Type.ELEMENT_WHITESPACE_COUNT);
        if (charge != 0) {
            this.setFormalCharge(charge);
        }
    }

    private static int parseCharge(String ss) {
        int i = 0;
        i = (ss = ss.trim()).equals("+") ? 1 : (ss.startsWith("+") ? Integer.parseInt(ss.substring(1)) : (ss.equals("-") ? -1 : (ss.endsWith("-") ? -Integer.parseInt(ss.substring(0, ss.length() - 1)) : Integer.parseInt(ss))));
        return i;
    }

    private int grabCharge(String ss, int i, int l) {
        char c = ss.charAt(i);
        if (i < l && (c == '-' || c == '+')) {
            ++i;
        }
        while (i < l && Character.isDigit(c = ss.charAt(i))) {
            ++i;
        }
        return i;
    }

    private int grabCount(String ss, int i, int l) {
        char c;
        if (this.allowNegativeCounts && i < l && ss.charAt(i) == '-') {
            ++i;
        }
        while (i < l && ((c = ss.charAt(i)) == '.' || Character.isDigit(c))) {
            ++i;
        }
        return i;
    }

    private int grabElement(String ss, int i, int l) {
        if (i < l && Character.isUpperCase(ss.charAt(i))) {
            ++i;
        }
        if (i < l && Character.isLowerCase(ss.charAt(i))) {
            ++i;
        }
        return i;
    }

    private int grabWhite(String ss, int i, int l) {
        while (i < l && Character.isWhitespace(ss.charAt(i))) {
            ++i;
        }
        return i;
    }

    public void add(String elementType, double count) {
        double[] counts;
        String[] elements;
        CMLAtomArray atomArray;
        CMLAtomArray cMLAtomArray = atomArray = this.getAtomArrayElements().size() == 0 ? null : this.getAtomArrayElements().get(0);
        if (atomArray == null) {
            this.normalize();
            if (atomArray == null) {
                atomArray = new CMLAtomArray();
                this.setAtomArray(atomArray);
                atomArray.setElementTypeAndCount(new String[0], new double[0]);
            }
        }
        if ((elements = this.getElementTypes()) == null) {
            elements = new String[]{};
        }
        if ((counts = this.getCounts()) == null) {
            counts = new double[]{};
        }
        int nelem = elements.length;
        boolean added = false;
        for (int i = 0; i < nelem; ++i) {
            if (!elements[i].equals(elementType)) continue;
            int n = i;
            counts[n] = counts[n] + count;
            added = true;
            break;
        }
        if (!added) {
            String[] newElem = new String[nelem + 1];
            System.arraycopy(elements, 0, newElem, 0, nelem);
            newElem[nelem] = elementType;
            double[] newCount = new double[nelem + 1];
            System.arraycopy(counts, 0, newCount, 0, nelem);
            newCount[nelem] = count;
            atomArray.setElementTypeAndCount(newElem, newCount);
        } else {
            atomArray.setElementTypeAndCount(elements, counts);
        }
        int formalCharge = this.getFormalChargeAttribute() == null ? 0 : this.getFormalCharge();
        String conciseS = atomArray.generateConcise(formalCharge);
        super.setConcise(conciseS);
    }

    public double[] getCounts() {
        CMLAtomArray atomArray = this.getAtomArrayElements().size() == 0 ? null : this.getAtomArrayElements().get(0);
        return atomArray == null ? null : atomArray.getCount();
    }

    public double getTotalAtomCount() {
        double[] counts = this.getCounts();
        if (counts == null) {
            return 0.0;
        }
        double total = 0.0;
        for (double count : counts) {
            total += count;
        }
        return total;
    }

    public String[] getElementTypes() {
        CMLAtomArray atomArray = this.getAtomArrayElements().size() == 0 ? null : this.getAtomArrayElements().get(0);
        return atomArray == null ? null : atomArray.getElementType();
    }

    public void multiplyBy(double d) {
        String concise;
        CMLAtomArray atomArray;
        CMLAtomArray cMLAtomArray = atomArray = this.getAtomArrayElements().size() == 0 ? null : this.getAtomArrayElements().get(0);
        if (atomArray != null) {
            String[] elems = this.getElementTypes();
            double[] counts = this.getCounts();
            int i = 0;
            while (i < counts.length) {
                int n = i++;
                counts[n] = counts[n] * d;
            }
            atomArray.setElementTypeAndCount(elems, counts);
        } else {
            concise = this.getConcise();
            CMLFormula fNew = new CMLFormula();
            fNew.createFromString(concise, Type.ELEMENT_WHITESPACE_COUNT);
            fNew.multiplyBy(d);
            String concise1 = fNew.getConcise();
            this.setConcise(concise1);
            CMLAtomArray fAtomArray = fNew.getAtomArrayElements().get(0);
            fAtomArray.detach();
            this.addAtomArray(fAtomArray);
        }
        concise = this.getAtomArrayElements().get(0).generateConcise((int)((double)this.getFormalCharge() * d));
        super.setConcise(concise);
    }

    public void addFormula(CMLFormula f) {
        CMLAtomArray atomArray = this.getAtomArrayElements().get(0);
        CMLElements<CMLFormula> formulas = this.getFormulaElements();
        if (formulas.size() == 0 && atomArray != null) {
            CMLFormula thisCopy = new CMLFormula(this);
            super.appendChild(thisCopy);
            atomArray.detach();
            CMLAttribute att = this.getConciseAttribute();
            if (att != null) {
                this.removeAttribute(att);
            }
            if ((att = this.getCountAttribute()) != null) {
                this.removeAttribute(att);
            }
        }
        if (atomArray != null) {
            CMLFormula ff = new CMLFormula(f);
            super.appendChild(ff);
        }
    }

    public CMLFormula getAggregateFormula() {
        CMLFormula newFormula = null;
        CMLElements<CMLFormula> formulas = this.getFormulaElements();
        if (formulas.size() == 0) {
            newFormula = this;
        } else {
            newFormula = new CMLFormula();
            for (CMLFormula formula : formulas) {
                newFormula = newFormula.createAggregatedFormula(formula);
            }
        }
        return newFormula;
    }

    public CMLFormula createAggregatedFormula(CMLFormula form) {
        if (form == null) {
            throw new RuntimeException("Null formula in createAggregatedFormula");
        }
        CMLFormula newFormula = new CMLFormula();
        newFormula.setAllowNegativeCounts(this.allowNegativeCounts | form.allowNegativeCounts);
        newFormula.aggregate(this);
        form = form.getAggregateFormula();
        newFormula.aggregate(form);
        return newFormula;
    }

    void aggregate(CMLFormula form) {
        int newCharge;
        int fCharge;
        String[] fElements = form.getElementTypes();
        double[] fCounts = form.getCounts();
        double thisCount = this.getCountAttribute() == null ? 1.0 : this.getCount();
        double fCount = form.getCountAttribute() == null ? 1.0 : form.getCount();
        int thisCharge = this.getFormalChargeAttribute() == null ? 0 : this.getFormalCharge();
        int n = fCharge = form.getFormalChargeAttribute() == null ? 0 : form.getFormalCharge();
        if (fElements != null) {
            for (int i = 0; i < fElements.length; ++i) {
                this.add(fElements[i], fCounts[i] * fCount);
            }
        } else {
            String concise = "";
            concise = form.getFormattedString(Type.ELEMENT_WHITESPACE_COUNT, Sort.CHFIRST, false).trim();
            if (this.getConciseAttribute() != null) {
                CMLFormula newForm = new CMLFormula();
                newForm.createFromString(concise, Type.ANY);
                this.aggregate(newForm);
            }
        }
        if ((newCharge = (int)((double)thisCharge * thisCount + (double)fCharge * fCount)) != 0) {
            this.setFormalCharge(newCharge);
        } else if (this.getFormalChargeAttribute() != null) {
            this.removeAttribute(this.getFormalChargeAttribute());
        }
        CMLAttribute countAttribute = this.getCountAttribute();
        if (countAttribute != null) {
            this.removeAttribute(this.getCountAttribute());
        }
        this.normalize();
    }

    @Override
    public double getCount() {
        double fCount = 1.0;
        if (this.getCountAttribute() != null && Math.round((float)(fCount = super.getCount())) == 0) {
            fCount = 1.0;
            this.setCount(fCount);
        }
        return fCount;
    }

    public Double getElementCount(String elementType) {
        String[] elementTypes = this.getElementTypes();
        double[] counts = this.getCounts();
        if (elementTypes != null) {
            for (int i = 0; i < elementTypes.length; ++i) {
                String el = elementTypes[i];
                if (!el.equals(elementType)) continue;
                return counts[i];
            }
        }
        return null;
    }

    public double divideBy(CMLFormula f, double eps) {
        double divide = Double.NaN;
        String[] elementTypes = this.getElementTypes();
        double[] counts = this.getCounts();
        if (f != null) {
            String[] fElem = f.getElementTypes();
            double[] fCounts = f.getCounts();
            if (fElem != null && fElem.length == elementTypes.length) {
                for (int i = 0; i < fElem.length; ++i) {
                    if (!elementTypes[i].equals(fElem[i]) || fCounts[i] == 0.0) {
                        divide = Double.NaN;
                        break;
                    }
                    double dd = counts[i] / fCounts[i];
                    if (Double.isNaN(divide)) {
                        divide = dd;
                        continue;
                    }
                    if (!(Math.abs(divide - dd) > eps)) continue;
                    divide = Double.NaN;
                    break;
                }
            }
        }
        return divide;
    }

    public double getCalculatedMolecularMass() throws RuntimeException {
        double mwt;
        block3: {
            block2: {
                mwt = 0.0;
                Elements formulas = this.getChildElements("formula", "http://www.xml-cml.org/schema");
                if (formulas.size() <= 0) break block2;
                for (int i = 0; i < formulas.size(); ++i) {
                    CMLFormula formula = (CMLFormula)formulas.get(i);
                    mwt += formula.getCalculatedMolecularMass();
                }
                break block3;
            }
            String[] elementTypes = this.getElementTypes();
            double[] counts = this.getCounts();
            if (counts == null) break block3;
            for (int i = 0; i < counts.length; ++i) {
                mwt += CMLFormula.getAtomicMass(elementTypes[i]) * counts[i];
            }
        }
        return this.getCount() * mwt;
    }

    private static double getAtomicMass(String elementType) {
        double mass = 0.0;
        if (elementType != null) {
            ChemicalElement el = ChemicalElement.getChemicalElement(elementType);
            mass = el == null ? 0.0 : el.getAtomicWeight();
        }
        return mass;
    }

    public static String createConcise(String s) {
        CMLFormula temp = CMLFormula.createFormula(s, Type.ANY);
        return temp == null ? null : temp.getConcise();
    }

    public String getFormattedString(Type convention, Sort sort, boolean omitCount1) throws RuntimeException {
        String s;
        CMLAtomArray atomArray;
        if (sort == null) {
            sort = Sort.CHFIRST;
        }
        if (!sort.equals((Object)Sort.CHFIRST) && !sort.equals((Object)Sort.ALPHABETIC_ELEMENTS)) {
            sort = Sort.CHFIRST;
        }
        if (convention == null || convention.equals("")) {
            convention = Type.NOPUNCTUATION;
        }
        if (!(convention.equals((Object)Type.NOPUNCTUATION) || convention.equals((Object)Type.NESTEDBRACKETS) || convention.equals((Object)Type.ELEMENT_WHITESPACE_COUNT) || convention.equals((Object)Type.ELEMENT_COUNT_WHITESPACE))) {
            convention = Type.NOPUNCTUATION;
        }
        this.normalize();
        CMLAtomArray cMLAtomArray = atomArray = this.getAtomArrayElements().size() == 0 ? null : this.getAtomArrayElements().get(0);
        if (atomArray != null) {
            atomArray.sort(sort);
        }
        StringBuffer sb = new StringBuffer();
        Elements formulas = this.getChildElements("formula", "http://www.xml-cml.org/schema");
        if (convention.equals((Object)Type.NESTEDBRACKETS)) {
            for (int i = 0; i < formulas.size(); ++i) {
                CMLFormula formula = (CMLFormula)formulas.get(i);
                String c = Util.outputNumber(10, 4, formula.getCount());
                if (!omitCount1 || !c.equals("1")) {
                    sb.append(c);
                }
                sb.append("(");
                sb.append(this.getFormattedString(convention, sort, omitCount1));
                sb.append(")");
            }
            return sb.toString();
        }
        this.combineSubFormulaElementVectors();
        if (atomArray != null) {
            atomArray.sort(sort);
        }
        String[] elementTypes = this.getElementTypes();
        double[] counts = this.getCounts();
        if (elementTypes != null && counts != null) {
            for (int i = 0; i < elementTypes.length; ++i) {
                sb.append(elementTypes[i]);
                s = Util.outputNumber(10, 4, counts[i]).trim();
                if (!omitCount1 || !s.equals("1")) {
                    if (convention.equals((Object)Type.ELEMENT_WHITESPACE_COUNT)) {
                        sb.append(" ");
                    }
                    sb.append(s);
                }
                if (!convention.equals((Object)Type.ELEMENT_WHITESPACE_COUNT) && !convention.equals((Object)Type.ELEMENT_COUNT_WHITESPACE)) continue;
                sb.append(" ");
            }
        }
        int l = sb.length();
        while (l > 0 && sb.charAt(--l) == ' ') {
            sb.deleteCharAt(l);
        }
        s = this.getFormalChargeString().trim();
        if (!s.equals("")) {
            if (!convention.equals((Object)Type.NOPUNCTUATION)) {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public int getFormalCharge() {
        int charge = 0;
        Elements childFormulas = this.getChildElements("formula", "http://www.xml-cml.org/schema");
        if (childFormulas.size() > 0) {
            for (int i = 0; i < childFormulas.size(); ++i) {
                CMLFormula childFormula = (CMLFormula)childFormulas.get(i);
                charge = (int)((double)charge + (double)childFormula.getFormalCharge() * childFormula.getCount());
            }
        } else if (this.getFormalChargeAttribute() != null) {
            charge = super.getFormalCharge();
        }
        return charge;
    }

    public String getFormalChargeString() {
        String s;
        block4: {
            s = "";
            int iCharge = this.getFormalCharge();
            if (iCharge == 0) break block4;
            if (iCharge < 0) {
                for (int i = iCharge; i < 0; ++i) {
                    s = s + "-";
                }
            } else {
                for (int i = 0; i < iCharge; ++i) {
                    s = s + "+";
                }
            }
        }
        return s;
    }

    public String getFormattedString() {
        return this.getFormattedString(null, null, true);
    }

    private void combineSubFormulaElementVectors() {
        Elements formulas = this.getChildElements("formula", "http://www.xml-cml.org/schema");
        if (formulas.size() > 0) {
            for (int i = 0; i < formulas.size(); ++i) {
                CMLFormula subFormula = (CMLFormula)formulas.get(i);
                String[] subElementTypes = subFormula.getElementTypes();
                double[] subCounts = subFormula.getCounts();
                for (int j = 0; j < subElementTypes.length; ++j) {
                    this.add(subElementTypes[j], subCounts[j] * subFormula.getCount());
                }
            }
        }
    }

    public static double getCalculatedMass(List<String> elementTypeVector, RealArray countArray) {
        if (elementTypeVector == null || countArray == null || elementTypeVector.size() != countArray.size()) {
            throw new RuntimeException("Bad arguments");
        }
        double mwt = 0.0;
        for (int i = 0; i < elementTypeVector.size(); ++i) {
            String elType = elementTypeVector.get(i);
            ChemicalElement el = ChemicalElement.getChemicalElement(elType);
            if (el == null) {
                throw new RuntimeException("Unsupported element: " + elType);
            }
            mwt += el.getAtomicWeight() * countArray.elementAt(i);
        }
        return mwt;
    }

    public void debug(Writer w) throws IOException {
        w.write("\n------------formula-------------\n");
        w.write(this.toString());
    }

    public boolean equals(CMLFormula form, double eps) {
        boolean equals = false;
        Object[] thisElem = this.getElementTypes();
        Object[] formElem = form.getElementTypes();
        boolean ee = Arrays.equals(thisElem, formElem);
        double[] thisCount = this.getCounts();
        double[] formCount = form.getCounts();
        if (thisCount == null) {
            thisCount = new double[]{};
        }
        if (formCount == null) {
            formCount = new double[]{};
        }
        boolean cc = Real.isEqual(thisCount, formCount, eps);
        if (ee && cc) {
            equals = true;
        }
        return equals;
    }

    public boolean equalsConcise(CMLFormula f) {
        boolean equals = false;
        equals = this.getConcise().equals(f.getConcise());
        return equals;
    }

    public CMLFormula getDifference(CMLFormula form) {
        Double count;
        double fCount;
        double thisCount;
        HashMap<String, Double> countTable = new HashMap<String, Double>();
        String[] elementTypes = this.getElementTypes();
        double[] counts = this.getCounts();
        double d = thisCount = this.getCountAttribute() == null ? 1.0 : this.getCount();
        if (elementTypes != null && counts != null) {
            for (int i = 0; i < elementTypes.length; ++i) {
                countTable.put(elementTypes[i], new Double(counts[i]));
            }
        }
        CMLFormula newFormula = new CMLFormula();
        newFormula.setAllowNegativeCounts(true);
        String[] fElementTypes = form.getElementTypes();
        double[] fCounts = form.getCounts();
        double d2 = fCount = form.getCountAttribute() == null ? 1.0 : form.getCount();
        if (fElementTypes != null && fCounts != null) {
            for (int i = 0; i < fElementTypes.length; ++i) {
                String element = fElementTypes[i];
                count = (Double)countTable.get(element);
                double delta = 0.0;
                delta = count == null ? 0.0 - fCounts[i] : count * thisCount - fCounts[i] * fCount;
                if (Math.abs(delta) > 1.0E-6) {
                    newFormula.add(element, delta);
                }
                countTable.remove(element);
            }
        }
        for (String element : countTable.keySet()) {
            count = (Double)countTable.get(element);
            if (count == null) continue;
            newFormula.add(element, count * thisCount);
        }
        int charge = (int)Math.round((double)this.getFormalCharge() * thisCount - (double)form.getFormalCharge() * fCount);
        if (charge != 0) {
            newFormula.setFormalCharge(charge);
        }
        return newFormula;
    }

    public boolean equalsAggregate(CMLFormula form) {
        CMLFormula differenceFormula = this.getDifference(form);
        return differenceFormula.isEmpty();
    }

    public boolean isEmpty() {
        boolean zero = true;
        String[] elementTypes = this.getElementTypes();
        double[] counts = this.getCounts();
        if (elementTypes != null && counts != null) {
            for (int i = 0; i < elementTypes.length; ++i) {
                if (Real.isZero(counts[i], Real.getEpsilon())) continue;
                zero = false;
                break;
            }
        }
        return zero;
    }

    public String toFormulaString() {
        String s = "count: " + this.getCount() + "; charge: " + this.getFormalCharge() + ": ";
        CMLElements<CMLFormula> formulas = this.getFormulaElements();
        for (CMLFormula formula : formulas) {
            s = s + "\nForm: " + formula.toFormulaString();
        }
        String[] elementTypes = this.getElementTypes();
        if (elementTypes != null) {
            double[] counts = this.getCounts();
            for (int i = 0; i < elementTypes.length; ++i) {
                double d = counts[i];
                s = s + elementTypes[i] + (d > 1.000000001 ? "(" + counts[i] + ")" : "");
            }
        }
        return s;
    }

    @Override
    public void writeHTML(Writer w) throws IOException {
        w.write("<span class='formula'>");
        CMLElements<CMLFormula> formulas = this.getFormulaElements();
        if (formulas.size() > 0) {
            for (CMLFormula formula : formulas) {
                double count = formula.getCount();
                w.write("(");
                formula.writeHTML(w);
                w.write(")");
                String cStr = String.valueOf(count);
                if (cStr.endsWith(".0")) {
                    cStr = cStr.substring(0, cStr.length() - 2);
                }
                if (cStr.equals("1")) continue;
                w.write("<sub>" + cStr + "</sub>");
            }
        } else {
            String[] elementTypes = this.getElementTypes();
            if (elementTypes != null) {
                double[] counts = this.getCounts();
                for (int i = 0; i < elementTypes.length; ++i) {
                    w.write(elementTypes[i]);
                    double d = counts[i];
                    int c = (int)Math.round(d);
                    String countS = "";
                    countS = Math.abs(d - (double)c) < 1.0E-14 ? "" + c : "" + d;
                    if (countS.equals("1")) continue;
                    w.write("<sub>" + countS + "</sub>");
                }
                if (this.getFormalChargeAttribute() != null) {
                    int fc = this.getFormalCharge();
                    int signum = Integer.signum(fc);
                    String sign = "";
                    if (signum == 1) {
                        sign = "+";
                    }
                    if (fc != 0) {
                        w.write("<sup>" + fc + sign + "</sup>");
                    }
                }
                w.write("</span>");
            }
        }
    }

    public static void mainTest(String[] args) {
        if (args.length == 0) {
            Util.println("Usage: FormulaImpl -IN xmlFile -OUT formFile -FORMAT format -MWT");
            Util.println("      Format NOSPACE EL_SPACE_COUNT EL_COUNT_SPACE");
            System.exit(0);
        }
        int i = 0;
        String infile = "";
        String outfile = "";
        String formatS = "";
        Type format = null;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-IN")) {
                infile = args[++i];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-OUT")) {
                outfile = args[++i];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-FORMAT")) {
                formatS = args[++i];
                ++i;
                continue;
            }
            System.err.println("Bad argument: " + args[i]);
            ++i;
        }
        if (formatS.equals("")) {
            formatS = "EL_SPACE_COUNT";
        }
        if (formatS.equals("EL_SPACE_COUNT")) {
            format = Type.ELEMENT_WHITESPACE_COUNT;
        } else if (formatS.equals("EL_COUNT_SPACE")) {
            format = Type.ELEMENT_COUNT_WHITESPACE;
        } else if (formatS.equals("NOSPACE")) {
            format = Type.NOPUNCTUATION;
        } else {
            System.err.println("Unsupported format: " + formatS);
        }
        try {
            if (!infile.equals("")) {
                CMLBuilder builder = new CMLBuilder();
                Document document = builder.build(new File(infile));
                Elements moleculeVector = document.getRootElement().getChildElements("molecule", "http://www.xml-cml.org/schema");
                ArrayList<String> formulaVector = new ArrayList<String>();
                for (i = 0; i < moleculeVector.size(); ++i) {
                    CMLMolecule molecule = (CMLMolecule)moleculeVector.get(i);
                    if (molecule == null) {
                        System.err.println("No molecule");
                        continue;
                    }
                    CMLFormula formula = (CMLFormula)molecule.getFirstChildElement("formula", "http://www.xml-cml.org/schema");
                    if (formula == null) continue;
                    String s = "<formula>" + formula.getFormattedString(format, Sort.CHFIRST, false) + "</formula>";
                    formulaVector.add(s);
                }
                if (!outfile.equals("")) {
                    FileWriter fw = new FileWriter(outfile);
                    fw.write("<cml>\n");
                    for (i = 0; i < formulaVector.size(); ++i) {
                        fw.write("" + (String)formulaVector.get(i) + "\n");
                    }
                    fw.write("</cml>\n");
                    fw.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAllowNegativeCounts() {
        return this.allowNegativeCounts;
    }

    public void setAllowNegativeCounts(boolean allowNegativeCounts) {
        this.allowNegativeCounts = allowNegativeCounts;
    }

    public boolean isProcessedConcise() {
        return this.processedConcise;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        ALPHABETIC_ELEMENTS("Alphabetic Elements", "AgCFHNOS"),
        CHFIRST("C and H first", "CHFNOS");

        String type;
        String example;

        private Sort(String type, String example) {
            this.type = type;
            this.example = example;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NOPUNCTUATION("NoPunctuation", "C2H4Cl2"),
        ELEMENT_COUNT_WHITESPACE("Element Count Whitespace", "C2 H4 Cl2"),
        ELEMENT_WHITESPACE_COUNT("Element Whitespace Count", "C 2 H 4 O 1"),
        CONCISE("CML Concise", "C 2 H 3 O 2 -1"),
        MULTIPLIED_ELEMENT_COUNT_WHITESPACE("Multiplied Element Whitespace Count", "3(C2 H4 Cl2) or (H2 O)3"),
        NESTEDBRACKETS("NestedBrackets", "Na2(SO4).10(H2O)"),
        IUPAC("IUPAC", "[V O (H2 O)5] 2(C7 H5 O6 S), 2H2 O"),
        MOIETY("Moiety", "(Cd 2+)3, (C6 N6 Cr 3-)2, 2(H2 O)"),
        SUBMOIETY("SubMoiety", "C6 N6 Cr 3-"),
        STRUCTURAL("STRUCTURAL", "Sn (C2 O4) K F"),
        ANY("Any", "(Cd 2+)3, (C6 N6 Cr 3-)2, 2(H2 O)");

        String type;
        String example;

        private Type(String type, String example) {
            this.type = type;
            this.example = example;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HydrogenStrategy {
        HYDROGEN_COUNT,
        EXPLICIT_HYDROGENS;

    }
}

