/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.tools.diff.AtomDiff;
import org.openscience.cdk.tools.diff.ElectronContainerDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class LonePairDiff {
    private LonePairDiff() {
    }

    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = LonePairDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof ILonePair) || !(second instanceof ILonePair)) {
            return null;
        }
        ILonePair firstB = (ILonePair)first;
        ILonePair secondB = (ILonePair)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("LonePairDiff");
        totalDiff.addChild(AtomDiff.difference(firstB.getAtom(), secondB.getAtom()));
        totalDiff.addChild(ElectronContainerDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

