/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKMCS;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRNode;
import org.openscience.cdk.smsd.tools.TimeManager;

@Deprecated
public class CDKRGraph {
    private List<CDKRNode> graph = new ArrayList<CDKRNode>();
    private int maxIteration = -1;
    private int firstGraphSize = 0;
    private int secondGraphSize = 0;
    private BitSet sourceBitSet = null;
    private BitSet targetBitSet = null;
    private List<BitSet> solutionList = new ArrayList<BitSet>();
    private boolean findAllMap = false;
    private boolean findAllStructure = true;
    private boolean stop = false;
    private int nbIteration = 0;
    private BitSet graphBitSet = new BitSet();

    private boolean checkTimeOut() throws CDKException {
        if (CDKMCS.isTimeOut()) {
            this.setStop(true);
            return true;
        }
        return false;
    }

    public int getFirstGraphSize() {
        return this.firstGraphSize;
    }

    public int getSecondGraphSize() {
        return this.secondGraphSize;
    }

    public void setFirstGraphSize(int graphSize) {
        this.firstGraphSize = graphSize;
    }

    public void setSecondGraphSize(int graphSize) {
        this.secondGraphSize = graphSize;
    }

    public void clear() {
        this.getGraph().clear();
        this.getGraphBitSet().clear();
    }

    public List<CDKRNode> getGraph() {
        return this.graph;
    }

    public void addNode(CDKRNode newNode) {
        this.getGraph().add(newNode);
        this.getGraphBitSet().set(this.getGraph().size() - 1);
    }

    public void parse(BitSet sourceBitSet, BitSet targetBitSet, boolean findAllStructure, boolean findAllMap, TimeManager timeManager) throws CDKException {
        this.checkTimeOut();
        this.getSolutionList().clear();
        BitSet bitSet = this.buildB(sourceBitSet, targetBitSet);
        this.setAllStructure(findAllStructure);
        this.setAllMap(findAllMap);
        this.parseRec(new BitSet(bitSet.size()), bitSet, new BitSet(bitSet.size()));
    }

    private void parseRec(BitSet traversed, BitSet extension, BitSet forbidden) throws CDKException {
        BitSet newTraversed = null;
        BitSet newExtension = null;
        BitSet newForbidden = null;
        BitSet potentialNode = null;
        this.checkTimeOut();
        if (extension.isEmpty()) {
            this.solution(traversed);
        } else {
            potentialNode = (BitSet)this.getGraphBitSet().clone();
            potentialNode.andNot(forbidden);
            potentialNode.or(traversed);
            if (this.mustContinue(potentialNode)) {
                this.setNbIteration(this.getNbIteration() + 1);
                int x = extension.nextSetBit(0);
                while (x >= 0 && !this.isStop()) {
                    newForbidden = (BitSet)forbidden.clone();
                    newForbidden.or(this.getGraph().get(x).getForbidden());
                    if (traversed.isEmpty()) {
                        newExtension = (BitSet)this.getGraph().get(x).getExtension().clone();
                    } else {
                        newExtension = (BitSet)extension.clone();
                        newExtension.or(this.getGraph().get(x).getExtension());
                    }
                    newExtension.andNot(newForbidden);
                    newTraversed = (BitSet)traversed.clone();
                    newTraversed.set(x);
                    forbidden.set(x);
                    this.parseRec(newTraversed, newExtension, newForbidden);
                    x = extension.nextSetBit(x + 1);
                }
            }
        }
    }

    private void solution(BitSet traversed) throws CDKException {
        boolean included = false;
        BitSet projG1 = this.projectG1(traversed);
        BitSet projG2 = this.projectG2(traversed);
        if (this.isContainedIn(this.getSourceBitSet(), projG1) && this.isContainedIn(this.getTargetBitSet(), projG2)) {
            ListIterator<BitSet> i = this.getSolutionList().listIterator();
            while (i.hasNext() && !included) {
                BitSet sol = (BitSet)i.next();
                this.checkTimeOut();
                if (!sol.equals(traversed)) {
                    if (this.isFindAllMap() && (projG1.equals(this.projectG1(sol)) || projG2.equals(this.projectG2(sol)))) continue;
                    if (this.isContainedIn(projG1, this.projectG1(sol)) || this.isContainedIn(projG2, this.projectG2(sol))) {
                        included = true;
                        continue;
                    }
                    if (!this.isContainedIn(this.projectG1(sol), projG1) && !this.isContainedIn(this.projectG2(sol), projG2)) continue;
                    i.remove();
                    continue;
                }
                included = true;
            }
            if (!included) {
                this.getSolutionList().add(traversed);
            }
            if (!this.isFindAllStructure()) {
                this.setStop(true);
            }
        }
    }

    private boolean mustContinue(BitSet potentialNode) {
        boolean result = true;
        boolean cancel = false;
        BitSet projG1 = this.projectG1(potentialNode);
        BitSet projG2 = this.projectG2(potentialNode);
        if (this.getMaxIteration() != -1 && this.getNbIteration() >= this.getMaxIteration()) {
            return false;
        }
        if (!this.isContainedIn(this.sourceBitSet, projG1) || !this.isContainedIn(this.targetBitSet, projG2)) {
            return false;
        }
        Iterator<BitSet> i = this.getSolutionList().iterator();
        while (i.hasNext() && !cancel) {
            BitSet sol = i.next();
            if (this.isFindAllMap() && (projG1.equals(this.projectG1(sol)) || projG2.equals(this.projectG2(sol))) || !this.isContainedIn(projG1, this.projectG1(sol)) && !this.isContainedIn(projG2, this.projectG2(sol))) continue;
            result = false;
            cancel = true;
        }
        return result;
    }

    private BitSet buildB(BitSet sourceBitSet, BitSet targetBitSet) throws CDKException {
        this.setSourceBitSet(sourceBitSet);
        this.setTargetBitSet(targetBitSet);
        BitSet bistSet = new BitSet();
        for (CDKRNode rNode : this.getGraph()) {
            this.checkTimeOut();
            if (!sourceBitSet.get(rNode.getRMap().getId1()) && !sourceBitSet.isEmpty() || !targetBitSet.get(rNode.getRMap().getId2()) && !targetBitSet.isEmpty()) continue;
            bistSet.set(this.getGraph().indexOf(rNode));
        }
        return bistSet;
    }

    public List<BitSet> getSolutions() {
        return this.getSolutionList();
    }

    public List<CDKRMap> bitSetToRMap(BitSet set) {
        ArrayList<CDKRMap> rMapList = new ArrayList<CDKRMap>();
        int x = set.nextSetBit(0);
        while (x >= 0) {
            CDKRNode xNode = this.getGraph().get(x);
            rMapList.add(xNode.getRMap());
            x = set.nextSetBit(x + 1);
        }
        return rMapList;
    }

    public void setAllStructure(boolean findAllStructure) {
        this.setFindAllStructure(findAllStructure);
    }

    public void setAllMap(boolean findAllMap) {
        this.setFindAllMap(findAllMap);
    }

    public void setMaxIteration(int maxIterator) {
        this.maxIteration = maxIterator;
    }

    public String toString() {
        String message = "";
        int jIndex = 0;
        for (CDKRNode rNode : this.getGraph()) {
            message = message + "-------------\nCDKRNode " + jIndex + "\n" + rNode.toString() + "\n";
            ++jIndex;
        }
        return message;
    }

    public BitSet projectG1(BitSet set) {
        BitSet projection = new BitSet(this.getFirstGraphSize());
        CDKRNode xNode = null;
        int x = set.nextSetBit(0);
        while (x >= 0) {
            xNode = this.getGraph().get(x);
            projection.set(xNode.getRMap().getId1());
            x = set.nextSetBit(x + 1);
        }
        return projection;
    }

    public BitSet projectG2(BitSet set) {
        BitSet projection = new BitSet(this.getSecondGraphSize());
        CDKRNode xNode = null;
        int x = set.nextSetBit(0);
        while (x >= 0) {
            xNode = this.getGraph().get(x);
            projection.set(xNode.getRMap().getId2());
            x = set.nextSetBit(x + 1);
        }
        return projection;
    }

    private boolean isContainedIn(BitSet sourceBitSet, BitSet targetBitSet) {
        boolean result = false;
        if (sourceBitSet.isEmpty()) {
            return true;
        }
        BitSet setA = (BitSet)sourceBitSet.clone();
        setA.and(targetBitSet);
        if (setA.equals(sourceBitSet)) {
            result = true;
        }
        return result;
    }

    private boolean isFindAllStructure() {
        return this.findAllStructure;
    }

    private void setFindAllStructure(boolean findAllStructure) {
        this.findAllStructure = findAllStructure;
    }

    private List<BitSet> getSolutionList() {
        return this.solutionList;
    }

    private BitSet getTargetBitSet() {
        return this.targetBitSet;
    }

    private void setTargetBitSet(BitSet targetBitSet) {
        this.targetBitSet = targetBitSet;
    }

    private BitSet getSourceBitSet() {
        return this.sourceBitSet;
    }

    private void setSourceBitSet(BitSet sourceBitSet) {
        this.sourceBitSet = sourceBitSet;
    }

    private int getMaxIteration() {
        return this.maxIteration;
    }

    private boolean isFindAllMap() {
        return this.findAllMap;
    }

    private void setFindAllMap(boolean findAllMap) {
        this.findAllMap = findAllMap;
    }

    private boolean isStop() {
        return this.stop;
    }

    private void setStop(boolean stop) {
        this.stop = stop;
    }

    private int getNbIteration() {
        return this.nbIteration;
    }

    private void setNbIteration(int nbIteration) {
        this.nbIteration = nbIteration;
    }

    private BitSet getGraphBitSet() {
        return this.graphBitSet;
    }
}

