/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.smiles.CxSmilesState;

final class CxSmilesParser {
    private static final char COMMA_SEPARATOR = ',';
    private static final char DOT_SEPARATOR = '.';

    private CxSmilesParser() {
    }

    private static boolean processAtomLabels(CharIter iter, Map<Integer, String> dest) {
        int atomIdx = 0;
        while (iter.hasNext()) {
            int beg;
            while (iter.nextIf(';')) {
                ++atomIdx;
            }
            char c = iter.next();
            if (c == '$') {
                iter.nextIf(',');
                return true;
            }
            iter.pos--;
            int rollback = beg = iter.pos;
            while (iter.hasNext()) {
                if (iter.pos == beg && iter.curr() == '_' && iter.peek() == 'R') {
                    ++beg;
                }
                if (iter.curr() == '&') {
                    rollback = iter.pos;
                    if (iter.nextIf('&') && iter.nextIf('#') && iter.nextIfDigit()) {
                        while (iter.nextIfDigit()) {
                        }
                        if (iter.nextIf(';')) continue;
                        iter.pos = rollback;
                        continue;
                    }
                    iter.pos = rollback;
                    continue;
                }
                if (iter.curr() == ';' || iter.curr() == '$') break;
                iter.next();
            }
            dest.put(atomIdx, CxSmilesParser.unescape(iter.substr(beg, iter.pos)));
            ++atomIdx;
            if (iter.nextIf('$')) {
                iter.nextIf(',');
                return true;
            }
            if (iter.nextIf(';')) continue;
            return false;
        }
        return false;
    }

    private static double readDouble(CharIter iter) {
        char c;
        int sign = 1;
        if (iter.nextIf('-')) {
            sign = -1;
        } else if (iter.nextIf('+')) {
            sign = 1;
        }
        double fracPart = 0.0;
        int divisor = 1;
        double intPart = CxSmilesParser.processUnsignedInt(iter);
        if (intPart < 0.0) {
            intPart = 0.0;
        }
        iter.nextIf('.');
        while (iter.hasNext() && CxSmilesParser.isDigit(c = iter.curr())) {
            fracPart *= 10.0;
            fracPart += (double)(c - 48);
            divisor *= 10;
            iter.next();
        }
        return (double)sign * (intPart + fracPart / (double)divisor);
    }

    private static boolean processCoords(CharIter iter, CxSmilesState state) {
        if (state.atomCoords == null) {
            state.atomCoords = new ArrayList<double[]>();
        }
        while (iter.hasNext()) {
            if (iter.curr() == ')') {
                iter.next();
                iter.nextIf(',');
                return true;
            }
            double x = CxSmilesParser.readDouble(iter);
            if (!iter.nextIf(',')) {
                return false;
            }
            double y = CxSmilesParser.readDouble(iter);
            if (!iter.nextIf(',')) {
                return false;
            }
            double z = CxSmilesParser.readDouble(iter);
            iter.nextIf(';');
            state.coordFlag = state.coordFlag || z != 0.0;
            state.atomCoords.add(new double[]{x, y, z});
        }
        return false;
    }

    private static boolean processFragmentGrouping(CharIter iter, CxSmilesState state) {
        if (state.fragGroups == null) {
            state.fragGroups = new ArrayList<List<Integer>>();
        }
        ArrayList<Integer> dest = new ArrayList<Integer>();
        while (iter.hasNext()) {
            dest.clear();
            if (!CxSmilesParser.processIntList(iter, '.', dest)) {
                return false;
            }
            iter.nextIf(',');
            if (dest.isEmpty()) {
                return true;
            }
            state.fragGroups.add(new ArrayList<Integer>(dest));
        }
        return false;
    }

    private static boolean isSgroupDelim(char c) {
        return c == ':' || c == ',' || c == '|';
    }

    private static boolean processDataSgroups(CharIter iter, CxSmilesState state) {
        ArrayList<Integer> atomset;
        if (state.dataSgroups == null) {
            state.dataSgroups = new ArrayList<CxSmilesState.DataSgroup>(4);
        }
        if (!CxSmilesParser.processIntList(iter, ',', atomset = new ArrayList<Integer>())) {
            return false;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        int beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String field = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            return false;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String value = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            state.dataSgroups.add(new CxSmilesState.DataSgroup(atomset, field, value, "", "", ""));
            return true;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String operator = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            state.dataSgroups.add(new CxSmilesState.DataSgroup(atomset, field, value, operator, "", ""));
            return true;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String unit = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            state.dataSgroups.add(new CxSmilesState.DataSgroup(atomset, field, value, operator, unit, ""));
            return true;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String tag = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        state.dataSgroups.add(new CxSmilesState.DataSgroup(atomset, field, value, operator, unit, tag));
        return true;
    }

    private static boolean processPolymerSgroups(CharIter iter, CxSmilesState state) {
        if (state.sgroups == null) {
            state.sgroups = new ArrayList<CxSmilesState.PolymerSgroup>();
        }
        int beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String keyword = iter.substr(beg, iter.pos);
        if (!iter.nextIf(':')) {
            return false;
        }
        ArrayList<Integer> atomset = new ArrayList<Integer>();
        if (!CxSmilesParser.processIntList(iter, ',', atomset)) {
            return false;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String subscript = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        if (subscript.isEmpty()) {
            subscript = keyword;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmilesParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String supscript = CxSmilesParser.unescape(iter.substr(beg, iter.pos));
        if (supscript.isEmpty()) {
            supscript = "eu";
        }
        if (iter.nextIf(',') || iter.curr() == '|') {
            state.sgroups.add(new CxSmilesState.PolymerSgroup(keyword, atomset, subscript, supscript));
            return true;
        }
        return false;
    }

    private static boolean processPositionalVariation(CharIter iter, CxSmilesState state) {
        if (state.positionVar == null) {
            state.positionVar = new TreeMap<Integer, List<Integer>>();
        }
        while (iter.hasNext()) {
            if (CxSmilesParser.isDigit(iter.curr())) {
                int beg = CxSmilesParser.processUnsignedInt(iter);
                if (!iter.nextIf(':')) {
                    return false;
                }
                ArrayList<Integer> endpoints = new ArrayList<Integer>(6);
                if (!CxSmilesParser.processIntList(iter, '.', endpoints)) {
                    return false;
                }
                iter.nextIf(',');
                state.positionVar.put(beg, endpoints);
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean processRadicals(CharIter iter, CxSmilesState state) {
        CxSmilesState.Radical rad;
        if (state.atomRads == null) {
            state.atomRads = new TreeMap<Integer, CxSmilesState.Radical>();
        }
        switch (iter.next()) {
            case '1': {
                rad = CxSmilesState.Radical.Monovalent;
                break;
            }
            case '2': {
                rad = CxSmilesState.Radical.Divalent;
                break;
            }
            case '3': {
                rad = CxSmilesState.Radical.DivalentSinglet;
                break;
            }
            case '4': {
                rad = CxSmilesState.Radical.DivalentTriplet;
                break;
            }
            case '5': {
                rad = CxSmilesState.Radical.Trivalent;
                break;
            }
            case '6': {
                rad = CxSmilesState.Radical.TrivalentDoublet;
                break;
            }
            case '7': {
                rad = CxSmilesState.Radical.TrivalentQuartet;
                break;
            }
            default: {
                return false;
            }
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        ArrayList<Integer> dest = new ArrayList<Integer>(4);
        if (!CxSmilesParser.processIntList(iter, ',', dest)) {
            return false;
        }
        for (Integer atomidx : dest) {
            state.atomRads.put(atomidx, rad);
        }
        return true;
    }

    static int processCx(String str, CxSmilesState state) {
        CharIter iter = new CharIter(str);
        if (!iter.nextIf('|')) {
            return -1;
        }
        block13: while (iter.hasNext()) {
            switch (iter.next()) {
                case '$': {
                    TreeMap<Integer, String> dest;
                    if (iter.nextIf("_AV:")) {
                        state.atomValues = new TreeMap<Integer, String>();
                        dest = state.atomValues;
                    } else {
                        state.atomLabels = new TreeMap<Integer, String>();
                        dest = state.atomLabels;
                    }
                    if (CxSmilesParser.processAtomLabels(iter, dest)) continue block13;
                    return -1;
                }
                case '(': {
                    if (CxSmilesParser.processCoords(iter, state)) continue block13;
                    return -1;
                }
                case 'c': 
                case 't': {
                    if (!(iter.nextIf(':') ? !CxSmilesParser.skipIntList(iter, ',') : iter.nextIf("tu:") && !CxSmilesParser.skipIntList(iter, ','))) continue block13;
                    return -1;
                }
                case 'r': {
                    if (!(iter.nextIf(':') ? !CxSmilesParser.skipIntList(iter, ',') : !iter.nextIf(',') && iter.curr() != '|')) continue block13;
                    return -1;
                }
                case 'l': {
                    if (!iter.nextIf("p:")) {
                        return -1;
                    }
                    if (CxSmilesParser.skipIntMap(iter)) continue block13;
                    return -1;
                }
                case 'f': {
                    if (!iter.nextIf(':')) {
                        return -1;
                    }
                    if (CxSmilesParser.processFragmentGrouping(iter, state)) continue block13;
                    return -1;
                }
                case 'S': {
                    if (iter.nextIf("g:")) {
                        if (CxSmilesParser.processPolymerSgroups(iter, state)) continue block13;
                        return -1;
                    }
                    if (iter.nextIf("gD:")) {
                        if (CxSmilesParser.processDataSgroups(iter, state)) continue block13;
                        return -1;
                    }
                    return -1;
                }
                case 'm': {
                    if (!iter.nextIf(':')) {
                        return -1;
                    }
                    if (CxSmilesParser.processPositionalVariation(iter, state)) continue block13;
                    return -1;
                }
                case '^': {
                    if (CxSmilesParser.processRadicals(iter, state)) continue block13;
                    return -1;
                }
                case 'C': 
                case 'H': {
                    if (!iter.nextIf(':')) {
                        return -1;
                    }
                    while (iter.hasNext() && CxSmilesParser.isDigit(iter.curr())) {
                        if (!CxSmilesParser.skipIntList(iter, '.')) {
                            return -1;
                        }
                        iter.nextIf(',');
                    }
                    continue block13;
                }
                case '|': {
                    if (!iter.nextIf(' ')) {
                        iter.nextIf('\t');
                    }
                    return iter.pos;
                }
            }
            return -1;
        }
        return -1;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean skipIntList(CharIter iter, char sep) {
        while (iter.hasNext()) {
            char c = iter.curr();
            if (CxSmilesParser.isDigit(c) || c == sep) {
                iter.next();
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean skipIntMap(CharIter iter) {
        while (iter.hasNext()) {
            char c = iter.curr();
            if (CxSmilesParser.isDigit(c) || c == ',' || c == ':') {
                iter.next();
                continue;
            }
            return true;
        }
        return false;
    }

    private static int processUnsignedInt(CharIter iter) {
        if (!iter.hasNext()) {
            return -1;
        }
        char c = iter.curr();
        if (!CxSmilesParser.isDigit(c)) {
            return -1;
        }
        int res = c - 48;
        iter.next();
        while (iter.hasNext() && CxSmilesParser.isDigit(c = iter.curr())) {
            res = res * 10 + c - 48;
            iter.next();
        }
        return res;
    }

    private static boolean processIntList(CharIter iter, char sep, List<Integer> dest) {
        while (iter.hasNext()) {
            char c = iter.curr();
            if (CxSmilesParser.isDigit(c)) {
                int r = CxSmilesParser.processUnsignedInt(iter);
                if (r < 0) {
                    return false;
                }
                iter.nextIf(sep);
                dest.add(r);
                continue;
            }
            return true;
        }
        return false;
    }

    static String unescape(String str) {
        int dst = 0;
        int src = 0;
        char[] chars = str.toCharArray();
        int len = chars.length;
        while (src < chars.length) {
            if (src + 3 < len && chars[src] == '&' && chars[src + 1] == '#' && CxSmilesParser.isDigit(chars[src + 2])) {
                int tmp;
                int code = 0;
                for (tmp = src + 2; tmp < len && CxSmilesParser.isDigit(chars[tmp]); ++tmp) {
                    code *= 10;
                    code += chars[tmp] - 48;
                }
                if (tmp < len && chars[tmp] == ';') {
                    src = tmp + 1;
                    chars[dst++] = (char)code;
                    continue;
                }
            }
            chars[dst++] = chars[src++];
        }
        return new String(chars, 0, dst);
    }

    private static final class CharIter {
        private final String str;
        private final int len;
        private int pos = 0;

        CharIter(String str) {
            this.str = str;
            this.len = str.length();
        }

        boolean nextIf(char c) {
            if (!this.hasNext() || this.str.charAt(this.pos) != c) {
                return false;
            }
            ++this.pos;
            return true;
        }

        boolean nextIfDigit() {
            if (!this.hasNext() || !CxSmilesParser.isDigit(this.str.charAt(this.pos))) {
                return false;
            }
            ++this.pos;
            return true;
        }

        boolean nextIf(String prefix) {
            boolean res = this.str.startsWith(prefix, this.pos);
            if (res) {
                this.pos += prefix.length();
            }
            return res;
        }

        boolean hasNext() {
            return this.pos < this.len;
        }

        char curr() {
            return this.str.charAt(this.pos);
        }

        char next() {
            return this.str.charAt(this.pos++);
        }

        public char peek() {
            return this.pos < this.str.length() ? this.str.charAt(this.pos + 1) : (char)'\u0000';
        }

        String substr(int beg, int end) {
            return this.str.substring(beg, end);
        }
    }
}

