/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemSubstanceXMLFormat;
import org.openscience.cdk.io.pubchemxml.PubChemXMLHelper;

public class PCCompoundXMLReader
extends DefaultChemObjectReader {
    private Reader input;
    private XMLStreamReader parser;
    private PubChemXMLHelper parserHelper;
    private IChemObjectBuilder builder;
    IAtomContainer molecule = null;

    public PCCompoundXMLReader(Reader input) throws Exception {
        this.setReader(input);
    }

    public PCCompoundXMLReader(InputStream input) throws Exception {
        this.setReader(input);
    }

    public PCCompoundXMLReader() throws Exception {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return PubChemSubstanceXMLFormat.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        try {
            XMLInputFactory xmlfact = XMLInputFactory.newFactory();
            xmlfact.setProperty("javax.xml.stream.isNamespaceAware", true);
            this.parser = xmlfact.createXMLStreamReader(input);
            this.input = input;
        }
        catch (Exception exception) {
            throw new CDKException("Error while creating reader: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        return IAtomContainer.class.isAssignableFrom(classObject);
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            try {
                this.parserHelper = new PubChemXMLHelper(object.getBuilder());
                this.builder = object.getBuilder();
                return (T)this.readMolecule();
            }
            catch (IOException e) {
                throw new CDKException("An IO Exception occurred while reading the file.", e);
            }
            catch (CDKException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CDKException("An error occurred: " + e.getMessage(), e);
            }
        }
        throw new CDKException("Only supported is reading of IAtomContainer objects.");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private IAtomContainer readMolecule() throws Exception {
        boolean foundCompound = false;
        while (this.parser.next() != 8) {
            if (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("PC-Compound")) continue;
            foundCompound = true;
            break;
        }
        if (foundCompound) {
            return this.parserHelper.parseMolecule(this.parser, this.builder);
        }
        return null;
    }
}

