/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import org.openscience.cdk.hash.AbstractAtomHashGenerator;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.AtomSuppression;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.hash.Suppressed;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.interfaces.IAtomContainer;

final class SuppressedAtomHashGenerator
extends AbstractAtomHashGenerator
implements AtomHashGenerator {
    private final AtomHashGenerator seedGenerator;
    private final StereoEncoderFactory factory;
    private final int depth;
    private final AtomSuppression suppression;

    public SuppressedAtomHashGenerator(AtomHashGenerator seedGenerator, Pseudorandom pseudorandom, StereoEncoderFactory factory, AtomSuppression suppression, int depth) {
        super(pseudorandom);
        if (seedGenerator == null) {
            throw new NullPointerException("seed generator cannot be null");
        }
        if (depth < 0) {
            throw new IllegalArgumentException("depth cannot be less then 0");
        }
        this.seedGenerator = seedGenerator;
        this.factory = factory;
        this.suppression = suppression;
        this.depth = depth;
    }

    public SuppressedAtomHashGenerator(AtomHashGenerator seedGenerator, Pseudorandom pseudorandom, AtomSuppression suppression, int depth) {
        this(seedGenerator, pseudorandom, StereoEncoderFactory.EMPTY, suppression, depth);
    }

    @Override
    public long[] generate(IAtomContainer container) {
        int[][] graph = SuppressedAtomHashGenerator.toAdjList(container);
        Suppressed suppressed = this.suppression.suppress(container);
        return this.generate(this.seedGenerator.generate(container), this.factory.create(container, graph), graph, suppressed);
    }

    @Override
    long[] generate(long[] current, StereoEncoder encoder, int[][] graph, Suppressed suppressed) {
        for (int i : suppressed.toArray()) {
            current[i] = Long.MAX_VALUE;
        }
        int n = graph.length;
        long[] next = SuppressedAtomHashGenerator.copy(current);
        long[] unique = new long[n];
        long[] included = new long[n];
        while (encoder.encode(current, next)) {
            SuppressedAtomHashGenerator.copy(next, current);
        }
        for (int d = 0; d < this.depth; ++d) {
            for (int v = 0; v < n; ++v) {
                next[v] = this.next(graph, v, current, unique, included, suppressed);
            }
            SuppressedAtomHashGenerator.copy(next, current);
            while (encoder.encode(current, next)) {
                SuppressedAtomHashGenerator.copy(next, current);
            }
        }
        for (int i : suppressed.toArray()) {
            current[i] = 0L;
        }
        return current;
    }

    long next(int[][] graph, int v, long[] current, long[] unique, long[] included, Suppressed suppressed) {
        if (suppressed.contains(v)) {
            return current[v];
        }
        long invariant = this.distribute(current[v]);
        int nUnique = 0;
        for (int w : graph[v]) {
            int i;
            if (suppressed.contains(w)) continue;
            long adjInv = current[w];
            for (i = 0; i < nUnique && unique[i] != adjInv; ++i) {
            }
            included[i] = i == nUnique ? (unique[nUnique++] = adjInv) : this.rotate(included[i]);
            invariant ^= included[i];
        }
        return invariant;
    }
}

