/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.matrix;

import org.openscience.cdk.graph.matrix.IGraphMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class ConnectionMatrix
implements IGraphMatrix {
    public static double[][] getMatrix(IAtomContainer container) {
        IBond bond = null;
        double[][] conMat = new double[container.getAtomCount()][container.getAtomCount()];
        for (int f = 0; f < container.getBondCount(); ++f) {
            bond = container.getBond(f);
            int indexAtom1 = container.indexOf(bond.getBegin());
            int indexAtom2 = container.indexOf(bond.getEnd());
            conMat[indexAtom1][indexAtom2] = BondManipulator.destroyBondOrder(bond.getOrder());
            conMat[indexAtom2][indexAtom1] = BondManipulator.destroyBondOrder(bond.getOrder());
        }
        return conMat;
    }
}

