/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.ChemObjectRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;

public class AtomRef
extends ChemObjectRef
implements IAtom {
    private final IAtom atom;

    public AtomRef(IAtom atom) {
        super(atom);
        this.atom = atom;
    }

    public static IAtom deref(IAtom atom) {
        while (atom instanceof AtomRef) {
            atom = ((AtomRef)atom).deref();
        }
        return atom;
    }

    public IAtom deref() {
        return this.atom;
    }

    @Override
    public Double getCharge() {
        return this.atom.getCharge();
    }

    @Override
    public void setCharge(Double charge) {
        this.atom.setCharge(charge);
    }

    @Override
    public Integer getAtomicNumber() {
        return this.atom.getAtomicNumber();
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.atom.setAtomicNumber(atomicNumber);
    }

    @Override
    public Double getNaturalAbundance() {
        return this.atom.getNaturalAbundance();
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        this.atom.setNaturalAbundance(naturalAbundance);
    }

    @Override
    public Integer getImplicitHydrogenCount() {
        return this.atom.getImplicitHydrogenCount();
    }

    @Override
    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.atom.setImplicitHydrogenCount(hydrogenCount);
    }

    @Override
    public Double getExactMass() {
        return this.atom.getExactMass();
    }

    @Override
    public void setExactMass(Double exactMass) {
        this.atom.setExactMass(exactMass);
    }

    @Override
    public String getSymbol() {
        return this.atom.getSymbol();
    }

    @Override
    public void setSymbol(String symbol) {
        this.atom.setSymbol(symbol);
    }

    @Override
    public Integer getMassNumber() {
        return this.atom.getMassNumber();
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        this.atom.setMassNumber(massNumber);
    }

    @Override
    public String getAtomTypeName() {
        return this.atom.getAtomTypeName();
    }

    @Override
    public void setAtomTypeName(String identifier) {
        this.atom.setAtomTypeName(identifier);
    }

    @Override
    public IBond.Order getMaxBondOrder() {
        return this.atom.getMaxBondOrder();
    }

    @Override
    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.atom.setMaxBondOrder(maxBondOrder);
    }

    @Override
    public Double getBondOrderSum() {
        return this.atom.getBondOrderSum();
    }

    @Override
    public void setBondOrderSum(Double bondOrderSum) {
        this.atom.setBondOrderSum(bondOrderSum);
    }

    @Override
    public Point2d getPoint2d() {
        return this.atom.getPoint2d();
    }

    @Override
    public void setPoint2d(Point2d point2d) {
        this.atom.setPoint2d(point2d);
    }

    @Override
    public Point3d getPoint3d() {
        return this.atom.getPoint3d();
    }

    @Override
    public void setPoint3d(Point3d point3d) {
        this.atom.setPoint3d(point3d);
    }

    @Override
    public Integer getFormalCharge() {
        return this.atom.getFormalCharge();
    }

    @Override
    public void setFormalCharge(Integer charge) {
        this.atom.setFormalCharge(charge);
    }

    @Override
    public Point3d getFractionalPoint3d() {
        return this.atom.getFractionalPoint3d();
    }

    @Override
    public void setFractionalPoint3d(Point3d point3d) {
        this.atom.setFractionalPoint3d(point3d);
    }

    @Override
    public Integer getFormalNeighbourCount() {
        return this.atom.getFormalNeighbourCount();
    }

    @Override
    public void setFormalNeighbourCount(Integer count) {
        this.atom.setFormalNeighbourCount(count);
    }

    @Override
    public Integer getStereoParity() {
        return this.atom.getStereoParity();
    }

    @Override
    public void setStereoParity(Integer stereoParity) {
        this.atom.setStereoParity(stereoParity);
    }

    @Override
    public IAtomType.Hybridization getHybridization() {
        return this.atom.getHybridization();
    }

    @Override
    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.atom.setHybridization(hybridization);
    }

    @Override
    public Double getCovalentRadius() {
        return this.atom.getCovalentRadius();
    }

    @Override
    public void setCovalentRadius(Double radius) {
        this.atom.setCovalentRadius(radius);
    }

    @Override
    public IAtomContainer getContainer() {
        return this.atom.getContainer();
    }

    @Override
    public int getIndex() {
        return this.atom.getIndex();
    }

    @Override
    public Integer getValency() {
        return this.atom.getValency();
    }

    @Override
    public void setValency(Integer valency) {
        this.atom.setValency(valency);
    }

    @Override
    public Iterable<IBond> bonds() {
        return this.atom.bonds();
    }

    @Override
    public int getBondCount() {
        return this.atom.getBondCount();
    }

    @Override
    public IBond getBond(IAtom atom) {
        return this.atom.getBond(atom);
    }

    @Override
    public boolean isAromatic() {
        return this.atom.isAromatic();
    }

    @Override
    public void setIsAromatic(boolean arom) {
        this.atom.setIsAromatic(arom);
    }

    @Override
    public boolean isInRing() {
        return this.atom.isInRing();
    }

    @Override
    public void setIsInRing(boolean ring) {
        this.atom.setIsInRing(ring);
    }

    public int hashCode() {
        return this.atom.hashCode();
    }

    public boolean equals(Object obj) {
        return this.atom.equals(obj);
    }

    @Override
    public IAtom clone() throws CloneNotSupportedException {
        return this.atom.clone();
    }

    @Override
    public String toString() {
        return "AtomRef{" + this.atom + "}";
    }
}

