/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Matching {
    private static final int UNMATCHED = -1;
    private final int[] match;

    private Matching(int n) {
        this.match = new int[n];
        Arrays.fill(this.match, -1);
    }

    boolean matched(int v) {
        return !this.unmatched(v);
    }

    boolean unmatched(int v) {
        int w = this.match[v];
        return w < 0 || this.match[w] != v;
    }

    int other(int v) {
        if (this.unmatched(v)) {
            throw new IllegalArgumentException(v + " is not matched");
        }
        return this.match[v];
    }

    void match(int u, int v) {
        this.match[u] = v;
        this.match[v] = u;
    }

    Iterable<Tuple> matches() {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(this.match.length / 2);
        for (int v = 0; v < this.match.length; ++v) {
            int w = this.match[v];
            if (w <= v || this.match[w] != v) continue;
            tuples.add(Tuple.of(v, w));
        }
        return tuples;
    }

    static Matching empty(Graph g) {
        return new Matching(g.order());
    }
}

