/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.features.MoleculeFeaturesTool;

public class DataFeaturesTool {
    public static int getSupportedDataFeatures(IAtomContainer molecule) {
        int features = 0;
        if (MoleculeFeaturesTool.hasElementSymbols(molecule)) {
            features |= 8;
        }
        if (GeometryTools.has2DCoordinates((IAtomContainer)molecule)) {
            features |= 1;
        }
        if (GeometryTools.has3DCoordinates((IAtomContainer)molecule)) {
            features |= 2;
        }
        if (CrystalGeometryTools.hasCrystalCoordinates((IAtomContainer)molecule)) {
            features |= 4;
        }
        if (MoleculeFeaturesTool.hasFormalCharges(molecule)) {
            features |= 0x20;
        }
        if (MoleculeFeaturesTool.hasPartialCharges(molecule)) {
            features |= 0x10;
        }
        if (MoleculeFeaturesTool.hasGraphRepresentation(molecule)) {
            features |= 0x200;
        }
        return features;
    }
}

