/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;

@TestClass(value="org.openscience.cdk.AssociationTest")
public class Association
extends ElectronContainer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -9138919895942850167L;
    protected final int electronCount = 0;
    protected IAtom[] atoms;
    protected int atomCount;

    @TestMethod(value="testAssociation_IAtom_IAtom")
    public Association(IAtom atom1, IAtom atom2) {
        this.atoms = new IAtom[2];
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.atomCount = 2;
    }

    @TestMethod(value="testAssociation")
    public Association() {
        this.atoms = new Atom[2];
        this.atomCount = 0;
    }

    @TestMethod(value="testGetAtoms")
    public IAtom[] getAtoms() {
        Atom[] returnAtoms = new Atom[this.atomCount];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    @TestMethod(value="testSetAtoms")
    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.notifyChanged();
    }

    @TestMethod(value="testGetAtomCount")
    public int getAtomCount() {
        return this.atomCount;
    }

    @TestMethod(value="testGetAtomAt")
    public Integer getElectronCount() {
        return 0;
    }

    @TestMethod(value="testGetAtomAt")
    public IAtom getAtomAt(int position) {
        return this.atoms[position];
    }

    @TestMethod(value="testContains")
    public boolean contains(IAtom atom) {
        for (IAtom atom1 : this.atoms) {
            if (atom1 != atom) continue;
            return true;
        }
        return false;
    }

    @TestMethod(value="testSetAtomAt")
    public void setAtomAt(IAtom atom, int position) {
        this.atoms[position] = atom;
        this.notifyChanged();
    }

    @TestMethod(value="testToString")
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Association(");
        s.append(this.hashCode());
        for (int i = 0; i < this.atomCount; ++i) {
            s.append(", ").append(this.atoms[i].toString());
        }
        s.append(")");
        return s.toString();
    }
}

