/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Iterator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.StateStream;
import org.openscience.cdk.isomorphism.VFState;
import org.openscience.cdk.isomorphism.VFSubState;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;

@TestClass(value="org.openscience.cdk.isomorphism.VentoFoggiaTest")
public final class VentoFoggia
extends Pattern {
    private final IAtomContainer query;
    private final int[][] g1;
    private final GraphUtil.EdgeToBondMap bonds1;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;
    private final boolean subgraph;
    private final boolean queryMatching;

    private VentoFoggia(IAtomContainer query, AtomMatcher atomMatcher, BondMatcher bondMatcher, boolean substructure) {
        this.query = query;
        this.atomMatcher = atomMatcher;
        this.bondMatcher = bondMatcher;
        this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)query);
        this.g1 = GraphUtil.toAdjList((IAtomContainer)query, (GraphUtil.EdgeToBondMap)this.bonds1);
        this.subgraph = substructure;
        this.queryMatching = query instanceof IQueryAtomContainer;
    }

    @Override
    @TestMethod(value="benzeneIdentical,benzeneSubsearch")
    public int[] match(IAtomContainer target) {
        return this.matchAll(target).stereochemistry().first();
    }

    @Override
    @TestMethod(value="benzeneIdentical,benzeneSubsearch")
    public Mappings matchAll(IAtomContainer target) {
        GraphUtil.EdgeToBondMap bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)target);
        int[][] g2 = GraphUtil.toAdjList((IAtomContainer)target, (GraphUtil.EdgeToBondMap)bonds2);
        VFIterable iterable = new VFIterable(this.query, target, this.g1, g2, this.bonds1, bonds2, this.atomMatcher, this.bondMatcher, this.subgraph);
        return new Mappings(this.query, target, iterable);
    }

    @TestMethod(value="benzeneSubsearch")
    public static Pattern findSubstructure(IAtomContainer query) {
        boolean isQuery = query instanceof IQueryAtomContainer;
        return new VentoFoggia(query, isQuery ? AtomMatcher.forQuery() : AtomMatcher.forElement(), isQuery ? BondMatcher.forQuery() : BondMatcher.forOrder(), true);
    }

    @TestMethod(value="benzeneIdentical")
    public static Pattern findIdentical(IAtomContainer query) {
        boolean isQuery = query instanceof IQueryAtomContainer;
        return new VentoFoggia(query, isQuery ? AtomMatcher.forQuery() : AtomMatcher.forElement(), isQuery ? BondMatcher.forQuery() : BondMatcher.forOrder(), false);
    }

    private static final class VFIterable
    implements Iterable<int[]> {
        private final IAtomContainer container1;
        private final IAtomContainer container2;
        private final int[][] g1;
        private final int[][] g2;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;
        private final AtomMatcher atomMatcher;
        private final BondMatcher bondMatcher;
        private final boolean subgraph;

        private VFIterable(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher, boolean subgraph) {
            this.container1 = container1;
            this.container2 = container2;
            this.g1 = g1;
            this.g2 = g2;
            this.bonds1 = bonds1;
            this.bonds2 = bonds2;
            this.atomMatcher = atomMatcher;
            this.bondMatcher = bondMatcher;
            this.subgraph = subgraph;
        }

        @Override
        public Iterator<int[]> iterator() {
            if (this.subgraph) {
                return new StateStream(new VFSubState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher));
            }
            return new StateStream(new VFState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher));
        }
    }
}

