/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.cml;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nu.xom.Node;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.dict.DictRef;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.tools.IDCreator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSchemeManipulator;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLBondType;
import org.xmlcml.cml.element.CMLCml;
import org.xmlcml.cml.element.CMLCrystal;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLIdentifier;
import org.xmlcml.cml.element.CMLList;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLMoleculeList;
import org.xmlcml.cml.element.CMLProduct;
import org.xmlcml.cml.element.CMLProductList;
import org.xmlcml.cml.element.CMLReactant;
import org.xmlcml.cml.element.CMLReactantList;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.element.CMLReactionList;
import org.xmlcml.cml.element.CMLReactionScheme;
import org.xmlcml.cml.element.CMLReactionStep;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.element.CMLSubstance;
import org.xmlcml.cml.element.CMLSubstanceList;

public class Convertor {
    public static final String NS_CML = "http://www.xml-cml.org/schema";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Convertor.class);
    private static final String CUSTOMIZERS_LIST = "libio-cml-customizers.set";
    private Map<String, ICMLCustomizer> customizers = null;
    private boolean useCMLIDs;
    private String prefix;

    public Convertor(boolean useCMLIDs, String prefix) {
        this.useCMLIDs = useCMLIDs;
        this.prefix = prefix;
        this.setupCustomizers();
    }

    public void registerCustomizer(ICMLCustomizer customizer) {
        if (this.customizers == null) {
            this.customizers = new HashMap<String, ICMLCustomizer>();
        }
        if (!this.customizers.containsKey(customizer.getClass().getName())) {
            this.customizers.put(customizer.getClass().getName(), customizer);
            logger.info("Loaded Customizer: ", customizer.getClass().getName());
        } else {
            logger.warn("Duplicate attempt to register a customizer");
        }
    }

    private void setupCustomizers() {
        if (this.customizers == null) {
            this.customizers = new HashMap<String, ICMLCustomizer>();
        }
        try {
            logger.debug("Starting loading Customizers...");
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(CUSTOMIZERS_LIST)));
            int customizerCount = 0;
            while (reader.ready()) {
                String customizerName = reader.readLine();
                ++customizerCount;
                if (this.customizers.containsKey(customizerName)) {
                    try {
                        ICMLCustomizer customizer = (ICMLCustomizer)this.getClass().getClassLoader().loadClass(customizerName).newInstance();
                        this.customizers.put(customizer.getClass().getName(), customizer);
                        logger.info("Loaded Customizer: ", customizer.getClass().getName());
                    }
                    catch (ClassNotFoundException exception) {
                        logger.info("Could not find this Customizer: ", customizerName);
                        logger.debug(exception);
                    }
                    catch (Exception exception) {
                        logger.warn("Could not load this Customizer: ", customizerName);
                        logger.warn(exception.getMessage());
                        logger.debug(exception);
                    }
                    continue;
                }
                logger.warn("Duplicate attempt to register a customizer");
            }
            logger.info("Number of loaded customizers: ", customizerCount);
        }
        catch (Exception exception) {
            logger.error("Could not load this list: ", CUSTOMIZERS_LIST);
            logger.debug(exception);
        }
    }

    public CMLCml cdkChemFileToCMLList(IChemFile file) {
        return this.cdkChemFileToCMLList(file, true);
    }

    private CMLCml cdkChemFileToCMLList(IChemFile file, boolean setIDs) {
        CMLCml cmlList = new CMLCml();
        cmlList.setConvention("cdk:document");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(file);
        }
        if (file.getID() != null && !file.getID().equals("")) {
            cmlList.setId(file.getID());
        }
        if (file.getChemSequenceCount() > 0) {
            Iterator<IChemSequence> sequences = file.chemSequences().iterator();
            while (sequences.hasNext()) {
                cmlList.appendChild(this.cdkChemSequenceToCMLList(sequences.next()));
            }
        }
        return cmlList;
    }

    public CMLList cdkChemSequenceToCMLList(IChemSequence sequence) {
        return this.cdkChemSequenceToCMLList(sequence, true);
    }

    private CMLList cdkChemSequenceToCMLList(IChemSequence sequence, boolean setIDs) {
        CMLList cmlList = new CMLList();
        cmlList.setConvention("cdk:sequence");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(sequence);
        }
        if (sequence.getID() != null && !sequence.getID().equals("")) {
            cmlList.setId(sequence.getID());
        }
        if (sequence.getChemModelCount() > 0) {
            for (int i = 0; i < sequence.getChemModelCount(); ++i) {
                cmlList.appendChild(this.cdkChemModelToCMLList(sequence.getChemModel(i)));
            }
        }
        return cmlList;
    }

    public CMLList cdkChemModelToCMLList(IChemModel model) {
        return this.cdkChemModelToCMLList(model, true);
    }

    private CMLList cdkChemModelToCMLList(IChemModel model, boolean setIDs) {
        CMLList cmlList = new CMLList();
        cmlList.setConvention("cdk:model");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(model);
        }
        if (model.getID() != null && !model.getID().equals("")) {
            cmlList.setId(model.getID());
        }
        if (model.getCrystal() != null) {
            cmlList.appendChild(this.cdkCrystalToCMLMolecule(model.getCrystal(), false));
        }
        if (model.getReactionSet() != null) {
            cmlList.appendChild(this.cdkReactionSetToCMLReactionList(model.getReactionSet(), false));
        }
        if (model.getMoleculeSet() != null) {
            cmlList.appendChild(this.cdkAtomContainerSetToCMLList(model.getMoleculeSet(), false));
        }
        return cmlList;
    }

    public CMLCml cdkReactionSchemeToCMLReactionSchemeAndMoleculeList(IReactionScheme cdkScheme) {
        CMLCml cml = new CMLCml();
        cml.appendChild(this.cdkAtomContainerSetToCMLList(ReactionSchemeManipulator.getAllAtomContainers(cdkScheme)));
        cml.appendChild(this.cdkReactionSchemeToCMLReactionScheme(cdkScheme, true, true));
        return cml;
    }

    public CMLReactionScheme cdkReactionSchemeToCMLReactionScheme(IReactionScheme cdkScheme) {
        return this.cdkReactionSchemeToCMLReactionScheme(cdkScheme, true, false);
    }

    private CMLReactionScheme cdkReactionSchemeToCMLReactionScheme(IReactionScheme cdkScheme, boolean setIDs, boolean isRef) {
        CMLReactionScheme reactionScheme = new CMLReactionScheme();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(cdkScheme);
        }
        if (cdkScheme.getID() != null && !cdkScheme.getID().equals("")) {
            reactionScheme.setId(cdkScheme.getID());
        }
        Iterator<IReaction> it = cdkScheme.reactions().iterator();
        while (it.hasNext()) {
            reactionScheme.appendChild(this.cdkReactionToCMLReaction(it.next(), true));
        }
        for (IReactionScheme intScheme : cdkScheme.reactionSchemes()) {
            reactionScheme.appendChild(this.cdkReactionSchemeToCMLReactionScheme(intScheme));
        }
        return reactionScheme;
    }

    public CMLReactionStep cdkReactionToCMLReactionStep(IReaction reaction) {
        return this.cdkReactionToCMLReactionStep(reaction, true);
    }

    private CMLReactionStep cdkReactionToCMLReactionStep(IReaction reaction, boolean setIDs) {
        CMLReactionStep reactionStep = new CMLReactionStep();
        reactionStep.appendChild(this.cdkReactionToCMLReaction(reaction, true));
        return reactionStep;
    }

    public CMLReactionList cdkReactionSetToCMLReactionList(IReactionSet reactionSet) {
        return this.cdkReactionSetToCMLReactionList(reactionSet, true);
    }

    private CMLReactionList cdkReactionSetToCMLReactionList(IReactionSet reactionSet, boolean setIDs) {
        CMLReactionList reactionList = new CMLReactionList();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(reactionSet);
        }
        if (reactionSet.getID() != null && !reactionSet.getID().equals("")) {
            reactionList.setId(reactionSet.getID());
        }
        Iterator<IReaction> reactionIter = reactionSet.reactions().iterator();
        while (reactionIter.hasNext()) {
            reactionList.appendChild(this.cdkReactionToCMLReaction(reactionIter.next(), false));
        }
        return reactionList;
    }

    public CMLMoleculeList cdkAtomContainerSetToCMLList(IAtomContainerSet moleculeSet) {
        return this.cdkAtomContainerSetToCMLList(moleculeSet, true);
    }

    private CMLMoleculeList cdkAtomContainerSetToCMLList(IAtomContainerSet moleculeSet, boolean setIDs) {
        CMLMoleculeList cmlList = new CMLMoleculeList();
        cmlList.setConvention("cdk:moleculeSet");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(moleculeSet);
        }
        if (moleculeSet.getID() != null && !moleculeSet.getID().equals("")) {
            cmlList.setId(moleculeSet.getID());
        }
        for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer container = moleculeSet.getAtomContainer(i);
            cmlList.appendChild(this.cdkAtomContainerToCMLMolecule(container, false, false));
        }
        return cmlList;
    }

    public CMLReaction cdkReactionToCMLReaction(IReaction reaction) {
        return this.cdkReactionToCMLReaction(reaction, true);
    }

    private CMLReaction cdkReactionToCMLReaction(IReaction reaction, boolean setIDs) {
        CMLReaction cmlReaction = new CMLReaction();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(reaction);
        }
        if (reaction.getID() != null && !reaction.getID().equals("")) {
            cmlReaction.setId(reaction.getID());
        }
        Map<Object, Object> props = reaction.getProperties();
        for (Object key : props.keySet()) {
            if (!(key instanceof String) || !(props.get(key) instanceof String)) continue;
            Object value = props.get(key);
            if (key.toString().equals("cdk:Title")) continue;
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setDictRef("cdk:reactionProperty");
            scalar.setTitle(key.toString());
            scalar.setValue(value.toString());
            cmlReaction.appendChild(scalar);
        }
        CMLReactantList cmlReactants = new CMLReactantList();
        Iterator<IAtomContainer> reactants = reaction.getReactants().atomContainers().iterator();
        while (reactants.hasNext()) {
            CMLReactant cmlReactant = new CMLReactant();
            cmlReactant.addMolecule(this.cdkAtomContainerToCMLMolecule(reactants.next()));
            cmlReactants.addReactant(cmlReactant);
        }
        CMLProductList cmlProducts = new CMLProductList();
        Iterator<IAtomContainer> products = reaction.getProducts().atomContainers().iterator();
        while (products.hasNext()) {
            CMLProduct cmlProduct = new CMLProduct();
            cmlProduct.addMolecule(this.cdkAtomContainerToCMLMolecule(products.next()));
            cmlProducts.addProduct(cmlProduct);
        }
        CMLSubstanceList cmlSubstances = new CMLSubstanceList();
        Iterator<IAtomContainer> substance = reaction.getAgents().atomContainers().iterator();
        while (substance.hasNext()) {
            CMLSubstance cmlSubstance = new CMLSubstance();
            cmlSubstance.addMolecule(this.cdkAtomContainerToCMLMolecule(substance.next()));
            cmlSubstances.addSubstance(cmlSubstance);
        }
        if (reaction.getID() != null) {
            cmlReaction.setId(reaction.getID());
        }
        cmlReaction.addReactantList(cmlReactants);
        cmlReaction.addProductList(cmlProducts);
        cmlReaction.addSubstanceList(cmlSubstances);
        return cmlReaction;
    }

    public CMLMolecule cdkCrystalToCMLMolecule(ICrystal crystal) {
        return this.cdkCrystalToCMLMolecule(crystal, true);
    }

    private CMLMolecule cdkCrystalToCMLMolecule(ICrystal crystal, boolean setIDs) {
        CMLMolecule molecule = this.cdkAtomContainerToCMLMolecule(crystal, false, false);
        CMLCrystal cmlCrystal = new CMLCrystal();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(crystal);
        }
        if (crystal.getID() != null && !crystal.getID().equals("")) {
            cmlCrystal.setId(crystal.getID());
        }
        this.checkPrefix(cmlCrystal);
        cmlCrystal.setZ(crystal.getZ());
        double[] params = CrystalGeometryTools.cartesianToNotional(crystal.getA(), crystal.getB(), crystal.getC());
        logger.debug("Number of cell params: ", params.length);
        cmlCrystal.setCellParameters(params);
        molecule.appendChild(cmlCrystal);
        return molecule;
    }

    public CMLMolecule cdkPDBPolymerToCMLMolecule(IPDBPolymer pdbPolymer) {
        return this.cdkPDBPolymerToCMLMolecule(pdbPolymer, true);
    }

    private CMLMolecule cdkPDBPolymerToCMLMolecule(IPDBPolymer pdbPolymer, boolean setIDs) {
        CMLMolecule cmlMolecule = new CMLMolecule();
        cmlMolecule.setConvention("PDB");
        cmlMolecule.setDictRef("pdb:model");
        Map<String, IStrand> mapS = pdbPolymer.getStrands();
        for (String key : mapS.keySet()) {
            IStrand strand = mapS.get(key);
            ArrayList<String> monomerNames = new ArrayList<String>(strand.getMonomerNames());
            Collections.sort(monomerNames);
            for (String name : monomerNames) {
                IMonomer monomer = strand.getMonomer(name);
                CMLMolecule clmono = this.cdkMonomerToCMLMolecule(monomer, true);
                cmlMolecule.appendChild(clmono);
            }
        }
        return cmlMolecule;
    }

    public CMLMolecule cdkMonomerToCMLMolecule(IMonomer monomer) {
        return this.cdkMonomerToCMLMolecule(monomer, true);
    }

    private CMLMolecule cdkMonomerToCMLMolecule(IMonomer monomer, boolean setIDs) {
        CMLMolecule cmlMolecule = new CMLMolecule();
        cmlMolecule.setDictRef("pdb:sequence");
        if (monomer.getMonomerName() != null && !monomer.getMonomerName().equals("")) {
            cmlMolecule.setId(monomer.getMonomerName());
        }
        for (int i = 0; i < monomer.getAtomCount(); ++i) {
            IAtom cdkAtom = monomer.getAtom(i);
            CMLAtom cmlAtom = this.cdkAtomToCMLAtom(monomer, cdkAtom);
            if (monomer.getConnectedSingleElectronsCount(cdkAtom) > 0) {
                cmlAtom.setSpinMultiplicity(monomer.getConnectedSingleElectronsCount(cdkAtom) + 1);
            }
            cmlMolecule.addAtom(cmlAtom);
        }
        return cmlMolecule;
    }

    public CMLMolecule cdkAtomContainerToCMLMolecule(IAtomContainer structure) {
        return this.cdkAtomContainerToCMLMolecule(structure, true, false);
    }

    private CMLMolecule cdkAtomContainerToCMLMolecule(IAtomContainer structure, boolean setIDs, boolean isRef) {
        CMLMolecule cmlMolecule = new CMLMolecule();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(structure);
        }
        this.checkPrefix(cmlMolecule);
        if (structure.getID() != null && !structure.getID().equals("")) {
            if (!isRef) {
                cmlMolecule.setId(structure.getID());
            } else {
                cmlMolecule.setRef(structure.getID());
            }
        }
        if (structure.getProperty("cdk:Title") != null) {
            cmlMolecule.setTitle((String)structure.getProperty("cdk:Title"));
        }
        if (structure.getProperty("cdk:InChI") != null) {
            CMLIdentifier ident = new CMLIdentifier();
            ident.setConvention("iupac:inchi");
            ident.setCMLValue(structure.getProperty("cdk:InChI").toString());
            cmlMolecule.appendChild(ident);
        }
        if (!isRef) {
            int i;
            for (i = 0; i < structure.getAtomCount(); ++i) {
                IAtom cdkAtom = structure.getAtom(i);
                CMLAtom cmlAtom = this.cdkAtomToCMLAtom(structure, cdkAtom);
                if (structure.getConnectedSingleElectronsCount(cdkAtom) > 0) {
                    cmlAtom.setSpinMultiplicity(structure.getConnectedSingleElectronsCount(cdkAtom) + 1);
                }
                cmlMolecule.addAtom(cmlAtom);
            }
            for (i = 0; i < structure.getBondCount(); ++i) {
                CMLBond cmlBond = this.cdkBondToCMLBond(structure.getBond(i));
                cmlMolecule.addBond(cmlBond);
            }
        }
        Map<Object, Object> props = structure.getProperties();
        for (Object key : props.keySet()) {
            if (key instanceof String && !isRef && props.get(key) instanceof String) {
                Object value = props.get(key);
                if (!key.toString().equals("cdk:Title") && !key.toString().equals("cdk:InChI")) {
                    CMLScalar scalar = new CMLScalar();
                    this.checkPrefix(scalar);
                    scalar.setDictRef("cdk:molecularProperty");
                    scalar.setTitle(key.toString());
                    scalar.setValue(value.toString());
                    cmlMolecule.addScalar(scalar);
                }
            }
            if (!(key instanceof String) || isRef || !key.toString().equals("cdk:Formula")) continue;
            if (props.get(key) instanceof IMolecularFormula) {
                IMolecularFormula cdkFormula = (IMolecularFormula)props.get(key);
                CMLFormula cmlFormula = new CMLFormula();
                List<IIsotope> isotopesList = MolecularFormulaManipulator.putInOrder(MolecularFormulaManipulator.generateOrderEle(), cdkFormula);
                for (int i = 0; i < isotopesList.size(); ++i) {
                    cmlFormula.add(isotopesList.get(i).getSymbol(), cdkFormula.getIsotopeCount(isotopesList.get(i)));
                }
                cmlMolecule.appendChild(cmlFormula);
                continue;
            }
            if (!(props.get(key) instanceof IMolecularFormulaSet)) continue;
            IMolecularFormulaSet cdkFormulaSet = (IMolecularFormulaSet)props.get(key);
            for (IMolecularFormula cdkFormula : cdkFormulaSet.molecularFormulas()) {
                List<IIsotope> isotopesList = MolecularFormulaManipulator.putInOrder(MolecularFormulaManipulator.generateOrderEle(), cdkFormula);
                CMLFormula cmlFormula = new CMLFormula();
                cmlFormula.setDictRef("cdk:possibleMachts");
                for (int i = 0; i < isotopesList.size(); ++i) {
                    cmlFormula.add(isotopesList.get(i).getSymbol(), cdkFormula.getIsotopeCount(isotopesList.get(i)));
                }
                cmlMolecule.appendChild(cmlFormula);
            }
        }
        Iterator<String> elements = this.customizers.keySet().iterator();
        while (elements.hasNext()) {
            ICMLCustomizer customizer = this.customizers.get(elements.next());
            try {
                customizer.customize(structure, (Object)cmlMolecule);
            }
            catch (Exception exception) {
                logger.error("Error while customizing CML output with customizer: ", customizer.getClass().getName());
                logger.debug(exception);
            }
        }
        return cmlMolecule;
    }

    private boolean addDictRef(IChemObject object, CMLElement cmlElement) {
        Map<Object, Object> properties = object.getProperties();
        for (Object key : properties.keySet()) {
            String keyName;
            if (!(key instanceof String) || !(keyName = (String)key).startsWith("org.openscience.cdk.dict")) continue;
            String dictRef = (String)properties.get(keyName);
            cmlElement.setProperty("dictRef", dictRef);
            return true;
        }
        return false;
    }

    private boolean addAtomID(IAtom cdkAtom, CMLAtom cmlAtom) {
        if (cdkAtom.getID() != null && !cdkAtom.getID().equals("")) {
            cmlAtom.setId(cdkAtom.getID());
        } else {
            cmlAtom.setId("a" + Integer.valueOf(cdkAtom.hashCode()).toString());
        }
        return true;
    }

    public CMLAtom cdkAtomToCMLAtom(IAtom cdkAtom) {
        return this.cdkAtomToCMLAtom(null, cdkAtom);
    }

    public CMLAtom cdkAtomToCMLAtom(IAtomContainer container, IAtom cdkAtom) {
        Integer totalHydrogen;
        CMLAtom cmlAtom = new CMLAtom();
        this.checkPrefix(cmlAtom);
        this.addAtomID(cdkAtom, cmlAtom);
        this.addDictRef(cdkAtom, cmlAtom);
        cmlAtom.setElementType(cdkAtom.getSymbol());
        if (cdkAtom instanceof IPseudoAtom) {
            String label = ((IPseudoAtom)cdkAtom).getLabel();
            if (label != null) {
                cmlAtom.setTitle(label);
            }
            cmlAtom.setElementType("Du");
        }
        this.map2DCoordsToCML(cmlAtom, cdkAtom);
        this.map3DCoordsToCML(cmlAtom, cdkAtom);
        this.mapFractionalCoordsToCML(cmlAtom, cdkAtom);
        Integer formalCharge = cdkAtom.getFormalCharge();
        if (formalCharge != null) {
            cmlAtom.setFormalCharge(formalCharge);
        }
        if ((totalHydrogen = cdkAtom.getImplicitHydrogenCount()) != null) {
            if (container != null) {
                Iterator<IBond> bonds = container.getConnectedBondsList(cdkAtom).iterator();
                while (bonds.hasNext()) {
                    for (IAtom atom : bonds.next().atoms()) {
                        if (!"H".equals(atom.getSymbol()) || atom == cdkAtom) continue;
                        Integer n = totalHydrogen;
                        Integer n2 = totalHydrogen = Integer.valueOf(totalHydrogen + 1);
                    }
                }
            }
            cmlAtom.setHydrogenCount(totalHydrogen);
        }
        Integer massNumber = cdkAtom.getMassNumber();
        if (!(cdkAtom instanceof IPseudoAtom) && massNumber != null) {
            cmlAtom.setIsotopeNumber(massNumber);
        }
        if (cdkAtom.getCharge() != CDKConstants.UNSET) {
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setDictRef("cdk:partialCharge");
            scalar.setValue(cdkAtom.getCharge());
            cmlAtom.addScalar(scalar);
        }
        this.writeProperties(cdkAtom, cmlAtom);
        if (cdkAtom.getFlag(32)) {
            CMLScalar aromAtom = new CMLScalar();
            aromAtom.setDictRef("cdk:aromaticAtom");
            cmlAtom.appendChild(aromAtom);
        }
        Iterator<String> elements = this.customizers.keySet().iterator();
        while (elements.hasNext()) {
            ICMLCustomizer customizer = this.customizers.get(elements.next());
            try {
                customizer.customize(cdkAtom, (Object)cmlAtom);
            }
            catch (Exception exception) {
                logger.error("Error while customizing CML output with customizer: ", customizer.getClass().getName());
                logger.debug(exception);
            }
        }
        return cmlAtom;
    }

    public CMLBond cdkBondToCMLBond(IBond cdkBond) {
        CMLBond cmlBond = new CMLBond();
        this.checkPrefix(cmlBond);
        if (cdkBond.getID() == null || cdkBond.getID().length() == 0) {
            cmlBond.setId("b" + cdkBond.hashCode());
        } else {
            cmlBond.setId(cdkBond.getID());
        }
        String[] atomRefArray = new String[cdkBond.getAtomCount()];
        for (int i = 0; i < cdkBond.getAtomCount(); ++i) {
            String atomID = cdkBond.getAtom(i).getID();
            atomRefArray[i] = atomID == null || atomID.length() == 0 ? "a" + Integer.valueOf(cdkBond.getAtom(i).hashCode()).toString() : atomID;
        }
        if (atomRefArray.length == 2) {
            cmlBond.setAtomRefs2(atomRefArray);
        } else {
            cmlBond.setAtomRefs(atomRefArray);
        }
        IBond.Order border = cdkBond.getOrder();
        if (border == CDKConstants.BONDORDER_SINGLE) {
            cmlBond.setOrder("S");
        } else if (border == CDKConstants.BONDORDER_DOUBLE) {
            cmlBond.setOrder("D");
        } else if (border == CDKConstants.BONDORDER_TRIPLE) {
            cmlBond.setOrder("T");
        } else {
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setDictRef("cdk:bondOrder");
            scalar.setTitle("order");
            scalar.setValue(cdkBond.getOrder().numeric());
            cmlBond.appendChild(scalar);
        }
        if (cdkBond.getFlag(32)) {
            CMLBondType bType = new CMLBondType();
            bType.setDictRef("cdk:aromaticBond");
            cmlBond.appendChild(bType);
        }
        if (cdkBond.getStereo() == IBond.Stereo.UP || cdkBond.getStereo() == IBond.Stereo.DOWN) {
            CMLBondStereo bondStereo = new CMLBondStereo();
            this.checkPrefix(bondStereo);
            if (cdkBond.getStereo() == IBond.Stereo.UP) {
                bondStereo.setDictRef("cml:W");
                bondStereo.setXMLContent("W");
            } else {
                bondStereo.setDictRef("cml:H");
                bondStereo.setXMLContent("H");
            }
            cmlBond.appendChild(bondStereo);
        }
        if (cdkBond.getProperties().size() > 0) {
            this.writeProperties(cdkBond, cmlBond);
        }
        Iterator<String> elements = this.customizers.keySet().iterator();
        while (elements.hasNext()) {
            ICMLCustomizer customizer = this.customizers.get(elements.next());
            try {
                customizer.customize(cdkBond, (Object)cmlBond);
            }
            catch (Exception exception) {
                logger.error("Error while customizing CML output with customizer: ", customizer.getClass().getName());
                logger.debug(exception);
            }
        }
        return cmlBond;
    }

    private void writeProperties(IChemObject object, CMLElement cmlElement) {
        Map<Object, Object> props = object.getProperties();
        Iterator<Object> keys = props.keySet().iterator();
        Node propList = null;
        while (keys.hasNext()) {
            String stringKey;
            Object key = keys.next();
            if (key instanceof DictRef) {
                Object value = props.get(key);
                CMLScalar scalar = new CMLScalar();
                this.checkPrefix(scalar);
                scalar.setDictRef(((DictRef)key).getType());
                scalar.setValue(value.toString());
                cmlElement.appendChild(scalar);
                continue;
            }
            if (!(key instanceof String) || (stringKey = (String)key).equals("cdk:Title") || stringKey.startsWith("org.openscience.cdk")) continue;
            Object value = props.get(key);
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setTitle((String)key);
            scalar.setValue(value.toString());
            cmlElement.appendChild(scalar);
        }
        if (propList != null) {
            cmlElement.appendChild(propList);
        }
    }

    private void mapFractionalCoordsToCML(CMLAtom cmlAtom, IAtom cdkAtom) {
        if (cdkAtom.getFractionalPoint3d() != null) {
            cmlAtom.setXFract(cdkAtom.getFractionalPoint3d().x);
            cmlAtom.setYFract(cdkAtom.getFractionalPoint3d().y);
            cmlAtom.setZFract(cdkAtom.getFractionalPoint3d().z);
        }
    }

    private void map3DCoordsToCML(CMLAtom cmlAtom, IAtom cdkAtom) {
        if (cdkAtom.getPoint3d() != null) {
            cmlAtom.setX3(cdkAtom.getPoint3d().x);
            cmlAtom.setY3(cdkAtom.getPoint3d().y);
            cmlAtom.setZ3(cdkAtom.getPoint3d().z);
        }
    }

    private void map2DCoordsToCML(CMLAtom cmlAtom, IAtom cdkAtom) {
        if (cdkAtom.getPoint2d() != null) {
            cmlAtom.setX2(cdkAtom.getPoint2d().x);
            cmlAtom.setY2(cdkAtom.getPoint2d().y);
        }
    }

    private void checkPrefix(CMLElement element) {
        if (this.prefix != null) {
            this.prefix.trim();
            if (this.prefix.length() == 0) {
                this.prefix = null;
            }
        }
        if (this.prefix != null) {
            element.setNamespacePrefix(this.prefix);
        }
    }
}

