/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.graph.rebond.RebondTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PDBFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.protein.data.PDBAtom;
import org.openscience.cdk.protein.data.PDBMonomer;
import org.openscience.cdk.protein.data.PDBPolymer;
import org.openscience.cdk.protein.data.PDBStrand;
import org.openscience.cdk.protein.data.PDBStructure;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.PDBReaderTest")
public class PDBReader
extends DefaultChemObjectReader {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PDBReader.class);
    private BufferedReader _oInput;
    private BooleanIOSetting useRebondTool;
    private BooleanIOSetting readConnect;
    private BooleanIOSetting useHetDictionary;
    private Map<Integer, IAtom> atomNumberMap;
    private ArrayList bondsFromConnectRecords;
    private static AtomTypeFactory pdbFactory;
    private Map<String, String> hetDictionary;
    private AtomTypeFactory cdkAtomTypeFactory;
    private static final String hetDictionaryPath = "org/openscience/cdk/config/data/type_map.txt";

    public PDBReader(InputStream oIn) {
        this(new InputStreamReader(oIn));
    }

    public PDBReader(Reader oIn) {
        this._oInput = new BufferedReader(oIn);
        this.initIOSettings();
        pdbFactory = null;
        this.hetDictionary = null;
        this.cdkAtomTypeFactory = null;
    }

    public PDBReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return PDBFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this._oInput = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T oObj) throws CDKException {
        if (oObj instanceof IChemFile) {
            if (pdbFactory == null) {
                try {
                    pdbFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/pdb_atomtypes.xml", ((IChemFile)oObj).getBuilder());
                }
                catch (Exception exception) {
                    logger.debug(exception);
                    throw new CDKException("Could not setup list of PDB atom types! " + exception.getMessage(), exception);
                }
            }
            return (T)this.readChemFile((IChemFile)oObj);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile oFile) {
        IChemSequence oSeq = oFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel oModel = oFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet oSet = oFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        PDBPolymer oBP = new PDBPolymer();
        IAtomContainer molecularStructure = oFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        String cRead = "";
        char chain = 'A';
        int lineLength = 0;
        boolean isProteinStructure = false;
        this.atomNumberMap = new Hashtable<Integer, IAtom>();
        if (this.readConnect.isSet()) {
            this.bondsFromConnectRecords = new ArrayList();
        }
        try {
            do {
                IStrand oStrand;
                PDBAtom oAtom;
                String cCol;
                cRead = this._oInput.readLine();
                logger.debug("Read line: ", cRead);
                if (cRead == null) continue;
                lineLength = cRead.length();
                if (lineLength < 80) {
                    logger.warn("Line is not of the expected length 80!");
                }
                if (lineLength < 6) {
                    cRead = cRead + "      ";
                }
                if ("SEQRES".equalsIgnoreCase(cCol = cRead.substring(0, 6))) {
                    isProteinStructure = true;
                    continue;
                }
                if ("ATOM  ".equalsIgnoreCase(cCol)) {
                    oAtom = this.readAtom(cRead, lineLength);
                    if (isProteinStructure) {
                        IMonomer oMonomer;
                        String strandName;
                        StringBuffer cResidue = new StringBuffer(8);
                        String oObj = oAtom.getResName();
                        if (oObj != null) {
                            cResidue = cResidue.append(oObj.trim());
                        }
                        if ((oObj = oAtom.getChainID()) != null) {
                            cResidue = cResidue.append(String.valueOf(chain));
                        }
                        if ((oObj = oAtom.getResSeq()) != null) {
                            cResidue = cResidue.append(oObj.trim());
                        }
                        if ((strandName = oAtom.getChainID()) == null || strandName.length() == 0) {
                            strandName = String.valueOf(chain);
                        }
                        if ((oStrand = oBP.getStrand(strandName)) == null) {
                            oStrand = new PDBStrand();
                            oStrand.setStrandName(strandName);
                            oStrand.setID(String.valueOf(chain));
                        }
                        if ((oMonomer = oBP.getMonomer(cResidue.toString(), String.valueOf(chain))) == null) {
                            PDBMonomer monomer = new PDBMonomer();
                            monomer.setMonomerName(cResidue.toString());
                            monomer.setMonomerType(oAtom.getResName());
                            monomer.setChainID(oAtom.getChainID());
                            monomer.setICode(oAtom.getICode());
                            monomer.setResSeq(oAtom.getResSeq());
                            oMonomer = monomer;
                        }
                        oBP.addAtom(oAtom, oMonomer, oStrand);
                    } else {
                        molecularStructure.addAtom(oAtom);
                    }
                    if (this.readConnect.isSet() && this.atomNumberMap.put(oAtom.getSerial(), oAtom) != null) {
                        logger.warn("Duplicate serial ID found for atom: ", oAtom);
                    }
                    logger.debug("Added ATOM: ", oAtom);
                    continue;
                }
                if ("HETATM".equalsIgnoreCase(cCol)) {
                    oAtom = this.readAtom(cRead, lineLength);
                    oAtom.setHetAtom(true);
                    if (isProteinStructure) {
                        oBP.addAtom(oAtom);
                    } else {
                        molecularStructure.addAtom(oAtom);
                    }
                    if (this.atomNumberMap.put(oAtom.getSerial(), oAtom) != null) {
                        logger.warn("Duplicate serial ID found for atom: ", oAtom);
                    }
                    logger.debug("Added HETATM: ", oAtom);
                    continue;
                }
                if ("TER   ".equalsIgnoreCase(cCol)) {
                    chain = (char)(chain + 1);
                    oStrand = new PDBStrand();
                    oStrand.setStrandName(String.valueOf(chain));
                    logger.debug("Added new STRAND");
                    continue;
                }
                if ("END   ".equalsIgnoreCase(cCol)) {
                    this.atomNumberMap.clear();
                    if (isProteinStructure) {
                        oSet.addAtomContainer(oBP);
                        if (!this.useRebondTool.isSet()) continue;
                        try {
                            if (this.createBondsWithRebondTool(oBP)) continue;
                            logger.info("Bonds could not be created using the RebondTool when PDB file was read.");
                            oBP.removeAllBonds();
                        }
                        catch (Exception exception) {
                            logger.info("Bonds could not be created when PDB file was read.");
                            logger.debug(exception);
                        }
                        continue;
                    }
                    this.createBondsWithRebondTool(molecularStructure);
                    oSet.addAtomContainer(molecularStructure);
                    continue;
                }
                if (cCol.equals("MODEL ")) {
                    if (isProteinStructure) {
                        if (oBP.getAtomCount() <= 0) continue;
                        oSet.addAtomContainer(oBP);
                        oModel.setMoleculeSet(oSet);
                        oSeq.addChemModel(oModel);
                        oBP = new PDBPolymer();
                        oModel = oFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                        oSet = oFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                        continue;
                    }
                    if (molecularStructure.getAtomCount() <= 0) continue;
                    oSet.addAtomContainer(molecularStructure);
                    oModel.setMoleculeSet(oSet);
                    oSeq.addChemModel(oModel);
                    molecularStructure = oFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                    oModel = oFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    oSet = oFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    continue;
                }
                if ("REMARK".equalsIgnoreCase(cCol)) {
                    Object comment = oFile.getProperty("cdk:Comment");
                    if (comment == null) {
                        comment = "";
                    }
                    if (lineLength > 12) {
                        comment = comment.toString() + cRead.substring(11).trim() + System.getProperty("line.separator");
                        oFile.setProperty("cdk:Comment", comment);
                        continue;
                    }
                    logger.warn("REMARK line found without any comment!");
                    continue;
                }
                if ("COMPND".equalsIgnoreCase(cCol)) {
                    String title = cRead.substring(10).trim();
                    oFile.setProperty("cdk:Title", title);
                    continue;
                }
                if (this.readConnect.isSet() && "CONECT".equalsIgnoreCase(cCol)) {
                    IAtomContainer molecule;
                    cRead.trim();
                    if (cRead.length() < 16) {
                        logger.debug("Skipping unexpected empty CONECT line! : ", cRead);
                        continue;
                    }
                    int lineIndex = 6;
                    int atomFromNumber = -1;
                    int atomToNumber = -1;
                    IAtomContainer iAtomContainer = molecule = isProteinStructure ? oBP : molecularStructure;
                    while (lineIndex + 5 <= cRead.length()) {
                        String part = cRead.substring(lineIndex, lineIndex + 5).trim();
                        if (atomFromNumber == -1) {
                            try {
                                atomFromNumber = Integer.parseInt(part);
                            }
                            catch (NumberFormatException nfe) {}
                        } else {
                            try {
                                atomToNumber = Integer.parseInt(part);
                            }
                            catch (NumberFormatException nfe) {
                                atomToNumber = -1;
                            }
                            if (atomFromNumber != -1 && atomToNumber != -1) {
                                this.addBond(molecule, atomFromNumber, atomToNumber);
                                logger.warn("Bonded " + atomFromNumber + " with " + atomToNumber);
                            }
                        }
                        lineIndex += 5;
                    }
                    continue;
                }
                if ("HELIX ".equalsIgnoreCase(cCol)) {
                    PDBStructure structure = new PDBStructure();
                    structure.setStructureType("helix");
                    structure.setStartChainID(Character.valueOf(cRead.charAt(19)));
                    structure.setStartSequenceNumber(Integer.parseInt(cRead.substring(21, 25).trim()));
                    structure.setStartInsertionCode(Character.valueOf(cRead.charAt(25)));
                    structure.setEndChainID(Character.valueOf(cRead.charAt(31)));
                    structure.setEndSequenceNumber(Integer.parseInt(cRead.substring(33, 37).trim()));
                    structure.setEndInsertionCode(Character.valueOf(cRead.charAt(37)));
                    oBP.addStructure(structure);
                    continue;
                }
                if ("SHEET ".equalsIgnoreCase(cCol)) {
                    PDBStructure structure = new PDBStructure();
                    structure.setStructureType("sheet");
                    structure.setStartChainID(Character.valueOf(cRead.charAt(21)));
                    structure.setStartSequenceNumber(Integer.parseInt(cRead.substring(22, 26).trim()));
                    structure.setStartInsertionCode(Character.valueOf(cRead.charAt(26)));
                    structure.setEndChainID(Character.valueOf(cRead.charAt(32)));
                    structure.setEndSequenceNumber(Integer.parseInt(cRead.substring(33, 37).trim()));
                    structure.setEndInsertionCode(Character.valueOf(cRead.charAt(37)));
                    oBP.addStructure(structure);
                    continue;
                }
                if (!"TURN  ".equalsIgnoreCase(cCol)) continue;
                PDBStructure structure = new PDBStructure();
                structure.setStructureType("turn");
                structure.setStartChainID(Character.valueOf(cRead.charAt(19)));
                structure.setStartSequenceNumber(Integer.parseInt(cRead.substring(20, 24).trim()));
                structure.setStartInsertionCode(Character.valueOf(cRead.charAt(24)));
                structure.setEndChainID(Character.valueOf(cRead.charAt(30)));
                structure.setEndSequenceNumber(Integer.parseInt(cRead.substring(31, 35).trim()));
                structure.setEndInsertionCode(Character.valueOf(cRead.charAt(35)));
                oBP.addStructure(structure);
            } while (this._oInput.ready() && cRead != null);
        }
        catch (Exception e) {
            logger.error("Found a problem at line:");
            logger.error(cRead);
            logger.error("01234567890123456789012345678901234567890123456789012345678901234567890123456789");
            logger.error("          1         2         3         4         5         6         7         ");
            logger.error("  error: " + e.getMessage());
            logger.debug(e);
            e.printStackTrace();
        }
        try {
            this._oInput.close();
        }
        catch (Exception e) {
            logger.debug(e);
        }
        oModel.setMoleculeSet(oSet);
        oSeq.addChemModel(oModel);
        oFile.addChemSequence(oSeq);
        return oFile;
    }

    private void addBond(IAtomContainer molecule, int bondAtomNo, int bondedAtomNo) {
        IAtom firstAtom = this.atomNumberMap.get(bondAtomNo);
        IAtom secondAtom = this.atomNumberMap.get(bondedAtomNo);
        if (firstAtom == null) {
            logger.error("Could not find bond start atom in map with serial id: ", bondAtomNo);
        }
        if (secondAtom == null) {
            logger.error("Could not find bond target atom in map with serial id: ", bondAtomNo);
        }
        IBond bond = firstAtom.getBuilder().newInstance(IBond.class, new Object[]{firstAtom, secondAtom, IBond.Order.SINGLE});
        for (int i = 0; i < this.bondsFromConnectRecords.size(); ++i) {
            IBond existingBond = (IBond)this.bondsFromConnectRecords.get(i);
            IAtom a = existingBond.getAtom(0);
            IAtom b = existingBond.getAtom(1);
            if ((a != firstAtom || b != secondAtom) && (b != firstAtom || a != secondAtom)) continue;
            return;
        }
        this.bondsFromConnectRecords.add(bond);
        molecule.addBond(bond);
    }

    private boolean createBondsWithRebondTool(IAtomContainer molecule) {
        RebondTool tool = new RebondTool(2.0, 0.5, 0.5);
        try {
            AtomTypeFactory factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt", molecule.getBuilder());
            for (IAtom atom : molecule.atoms()) {
                try {
                    IAtomType[] types = factory.getAtomTypes(atom.getSymbol());
                    if (types.length > 0) {
                        AtomTypeManipulator.configure(atom, types[0]);
                        continue;
                    }
                    logger.warn("Could not configure atom with symbol: " + atom.getSymbol());
                }
                catch (Exception e) {
                    logger.warn("Could not configure atom (but don't care): " + e.getMessage());
                    logger.debug(e);
                }
            }
            tool.rebond(molecule);
        }
        catch (Exception e) {
            logger.error("Could not rebond the polymer: " + e.getMessage());
            logger.debug(e);
        }
        return true;
    }

    private PDBAtom readAtom(String cLine, int lineLength) {
        String oxt;
        String frag;
        boolean isHetatm;
        String elementSymbol;
        if (lineLength < 59) {
            throw new RuntimeException("PDBReader error during readAtom(): line too short");
        }
        if (cLine.length() > 78) {
            elementSymbol = cLine.substring(76, 78).trim();
            if (elementSymbol.length() == 0) {
                elementSymbol = cLine.substring(12, 14).trim();
            }
        } else {
            elementSymbol = cLine.substring(12, 14).trim();
        }
        if (elementSymbol.length() == 2) {
            elementSymbol = Character.isDigit(elementSymbol.charAt(0)) ? elementSymbol.substring(1) : elementSymbol.charAt(0) + elementSymbol.substring(1).toLowerCase();
        }
        String rawAtomName = cLine.substring(12, 16).trim();
        String resName = cLine.substring(17, 20).trim();
        try {
            IAtomType type = pdbFactory.getAtomType(resName + "." + rawAtomName);
            elementSymbol = type.getSymbol();
            isHetatm = false;
        }
        catch (NoSuchAtomTypeException e) {
            logger.error("Did not recognize PDB atom type: " + resName + "." + rawAtomName);
            isHetatm = true;
        }
        PDBAtom oAtom = new PDBAtom(elementSymbol, new Point3d(Double.parseDouble(cLine.substring(30, 38)), Double.parseDouble(cLine.substring(38, 46)), Double.parseDouble(cLine.substring(46, 54))));
        if (this.useHetDictionary.isSet() && isHetatm) {
            String cdkType = this.typeHetatm(resName, rawAtomName);
            oAtom.setAtomTypeName(cdkType);
            if (cdkType != null) {
                try {
                    this.cdkAtomTypeFactory.configure(oAtom);
                }
                catch (CDKException cdke) {
                    logger.warn("Could not configure", resName, " ", rawAtomName);
                }
            }
        }
        oAtom.setRecord(cLine);
        oAtom.setSerial(Integer.parseInt(cLine.substring(6, 11).trim()));
        oAtom.setName(rawAtomName.trim());
        oAtom.setAltLoc(cLine.substring(16, 17).trim());
        oAtom.setResName(resName);
        oAtom.setChainID(cLine.substring(21, 22).trim());
        oAtom.setResSeq(cLine.substring(22, 26).trim());
        oAtom.setICode(cLine.substring(26, 27).trim());
        if (this.useHetDictionary.isSet() && isHetatm) {
            oAtom.setID(oAtom.getResName() + "." + rawAtomName);
        } else {
            oAtom.setAtomTypeName(oAtom.getResName() + "." + rawAtomName);
        }
        if (lineLength >= 59 && (frag = cLine.substring(54, 60).trim()).length() > 0) {
            oAtom.setOccupancy(Double.parseDouble(frag));
        }
        if (lineLength >= 65 && (frag = cLine.substring(60, 66).trim()).length() > 0) {
            oAtom.setTempFactor(Double.parseDouble(frag));
        }
        if (lineLength >= 75) {
            oAtom.setSegID(cLine.substring(72, 76).trim());
        }
        if (lineLength >= 79 && (frag = lineLength >= 80 ? cLine.substring(78, 80).trim() : cLine.substring(78)).length() > 0) {
            if (frag.endsWith("-") || frag.endsWith("+")) {
                oAtom.setCharge(Double.parseDouble(new StringBuilder(frag).reverse().toString()));
            } else {
                oAtom.setCharge(Double.parseDouble(frag));
            }
        }
        if ((oxt = cLine.substring(13, 16).trim()).equals("OXT")) {
            oAtom.setOxt(true);
        } else {
            oAtom.setOxt(false);
        }
        return oAtom;
    }

    private String typeHetatm(String resName, String atomName) {
        String key;
        if (this.hetDictionary == null) {
            this.readHetDictionary();
            this.cdkAtomTypeFactory = AtomTypeFactory.getInstance("org/openscience/cdk/dict/data/cdk-atom-types.owl", DefaultChemObjectBuilder.getInstance());
        }
        if (this.hetDictionary.containsKey(key = resName + "." + atomName)) {
            return this.hetDictionary.get(key);
        }
        return null;
    }

    private void readHetDictionary() {
        try {
            String line;
            InputStream ins = this.getClass().getClassLoader().getResourceAsStream(hetDictionaryPath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ins));
            this.hetDictionary = new HashMap<String, String>();
            while ((line = bufferedReader.readLine()) != null) {
                int colonIndex = line.indexOf(":");
                if (colonIndex == -1) continue;
                String typeKey = line.substring(0, colonIndex);
                String typeValue = line.substring(colonIndex + 1);
                if (typeValue.equals("null")) {
                    this.hetDictionary.put(typeKey, null);
                    continue;
                }
                this.hetDictionary.put(typeKey, typeValue);
            }
            bufferedReader.close();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this._oInput.close();
    }

    private void initIOSettings() {
        this.useRebondTool = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("UseRebondTool", IOSetting.Importance.LOW, "Should the PDBReader deduce bonding patterns?", "false"));
        this.readConnect = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("ReadConnectSection", IOSetting.Importance.LOW, "Should the CONECT be read?", "true"));
        this.useHetDictionary = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("UseHetDictionary", IOSetting.Importance.LOW, "Should the PDBReader use the HETATM dictionary for atom types?", "false"));
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }
}

